// ObserverSwarm.m
//--------------------------------------------------------------------

#import <activity.h>
#import <simtoolsgui.h>
#import "ObserverSwarm.h"

@implementation ObserverSwarm

//--------------------------------------------------------------------

+ createBegin: aZone
{

   ObserverSwarm *obj;

   id <ProbeMap> probeMap;

TRACE1(printf("\n%8X ObserverSwarm - entry createBegin\n",(int) self);)

   // createBegin: here we set up the default simulation parameters.
   // Superclass createBegin to allocate ourselves.

   obj = [super createBegin: aZone];

   // Fill in the relevant parameters (only one, in this case).

   obj->displayFrequency   = 1000;

   // Also, build a customized probe map. Without a probe map, the default
   // is to show all variables and messages. Here we choose to
   // customize the appearance of the probe, give a nicer interface.

   probeMap = [EmptyProbeMap createBegin: aZone];
   [probeMap setProbedClass: [self class]];
   probeMap = [probeMap createEnd];

   // Add in a bunch of variables, one per simulation parameters

   [probeMap addProbe: [probeLibrary getProbeForVariable:
              "displayFrequency" inClass: [self class]]];
   // Now install our custom probeMap into the probeLibrary.

   [probeLibrary setProbeMap: probeMap For: [self class]];

TRACE1(printf("%8X ObserverSwarm - exit createBegin %8X\n\n",
       (int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------
//Here we set initial values of counters and constant eyeCatcher
//that will be useful to find the area in a memory-dump

- createEnd
{

   id obj;

TRACE1(printf("\n%8X ObserverSwarm - entry createEnd\n",(int) self);)

   obj = [super createEnd];

TRACE1(printf("%8X ObserverSwarm - exit createEnd %8X\n\n",
              (int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------

- buildObjects
{

//   int numberOfAgents;

TRACE1(printf("\n%8X ObserverSwarm - entry buildObjects\n",(int) self);)

   [super buildObjects];

   // First, we create the model that we're actually observing. The
   // model is a subswarm of the observer.
   // We create in the modelSwarm in "self" which creates a modelSwarm
   // in it's *own* Zone within the observerSwarm.

   modelSwarm = [ModelSwarm create: self];

   // Now create probe objects on the model and ourselves. This gives a
   // simple user interface to let the user change parameters.

   CREATE_PROBE_DISPLAY (modelSwarm);
   CREATE_PROBE_DISPLAY (self);

   // Instruct the control panel to wait for a button event.
   // We halt here until someone hits a control panel button.
   // Now that we're using Probes, the user can set the parameters
   // in the ModelSwarm probe window - we halt here to allow
   // the user to change parameters.

   [controlPanel setStateStopped];

   // When the user hits "go" on the control panel, we resume here
   // OK - the user said "go" so we're ready to start

   [modelSwarm buildObjects];

TRACE1(printf("%8X ObserverSwarm - exit buildObjects %8X\n\n",
                (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- buildActions
{

//   int i;

TRACE1(printf("\n%8X ObserverSwarm - entry buildActions\n",(int) self);)

   // Create the actions necessary for the simulation.

   [super buildActions];

   // First, let our model swarm build its own schedule.

   [modelSwarm buildActions];

   // Create an ActionGroup for display.

   controlActions   = [ActionGroup create: self];

   // Schedule up the methods to draw the display of the world

   [controlActions createActionTo: modelSwarm
                               message: M(print)];
   [controlActions createActionTo: actionCache  message: M(doTkEvents)];

   // And the display schedule. Note the repeat interval is set from our
   // own Swarm data structure. Display is frequently the slowest part of a
   // simulation, so redrawing less frequently can be a help.
   displaySchedule = [Schedule createBegin: self];
   [displaySchedule setRepeatInterval: displayFrequency];
   displaySchedule = [displaySchedule createEnd];
   [displaySchedule at: 0 createAction: controlActions];

TRACE1(printf("%8X ObserverSwarm - exit buildActions %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- activateIn: swarmContext
{

// activateIn: - activate the schedules so they're ready to run.

TRACE1(printf("\n%8X ObserverSwarm - entry activateIn\n",(int) self);)

   [super activateIn: swarmContext];

   // Activate the model swarm in ourselves. The model swarm is a
   // subswarm of the observer swarm.

   [modelSwarm activateIn: self];

   // Now activate our schedule in ourselves. This arranges for the
   // execution of the schedule we built.

   [displaySchedule activateIn: self];

   // Activate returns the swarm activity - the thing that's ready to run.

TRACE1(printf("%8X ObserverSwarm - exit activateIn %8X\n\n",
              (int) self,(int) [self getSwarmActivity]);)

   return [self getSwarmActivity];

}

//--------------------------------------------------------------------
@end
