// ModelSwarm.m
//--------------------------------------------------------------------

#import <activity.h>
#import <collections.h>
#import "ModelSwarm.h"

//--------------------------------------------------------------------

@implementation ModelSwarm

//--------------------------------------------------------------------

+ createBegin: aZone
{

   ModelSwarm *obj;
   id <ProbeMap> probeMap;

   // Macro TRACEx is for debug and acts accordingly with the content of
   // the file macro.h - In distributed version of trace.h all TRACEx is
   // translated in a comment. For more information see the notes at the
   // top of the file trace.h 

TRACE2(printf("\n%8X ModelSwarm - entry createBegin\n",(int) self);)

   // in createBegin, we set up the simulation parameters
   // First, call our superclass createBegin - the return value is the
   // allocated Swarm object.

   obj = [super createBegin: aZone];

   // Now fill in various simulation parameters with default values.

   obj->numberOfInterfaces  = 9;
   obj->lengthOfGenoma      = 16;
   obj->turnoverRate        = 0.5;
   obj->crossoverRate       = 0.5;
   obj->mutationRate        = 0.001;
   obj->evolutionFrequency  = 1;
   obj->childrenFitness     = 0;
   obj->useDeltaFitness     = 0;

   // Build a customized probe map. Without a probe map, the default
   // is to show all variables and messages. Here we choose to
   // customize the appearance of the probe, give a nicer interface.

   probeMap = [EmptyProbeMap createBegin: aZone];
   [probeMap setProbedClass: [self class]];
   probeMap = [probeMap createEnd];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "numberOfInterfaces" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "lengthOfGenoma" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "turnoverRate" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "crossoverRate" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "mutationRate" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "evolutionFrequency" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "childrenFitness" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "useDeltaFitness" inClass: [self class]]];

   // Now install our custom probeMap into the probeLibrary.

   [probeLibrary setProbeMap: probeMap For: [self class]];

TRACE2(printf("%8X ModelSwarm - exit createBegin %8X\n\n",(int)self,(int)obj);)

   return obj;

}

//--------------------------------------------------------------------

- createEnd
{

   id obj;

TRACE2(printf("\n%8X ModelSwarm - entry createEnd\n",(int)self);)

   obj = [super createEnd];

TRACE2(printf("%8X ModelSwarm - exit createEnd %8X\n\n",(int)self,
             (int)obj);)

   return obj;

}

//--------------------------------------------------------------------

- buildObjects
{

   // Here we create instances for objects before createEnd, for each,
   // the initial topic values are set using specific methods

   Interface      * anInterface;
   int i;

TRACE2 (printf("\n%8X ModelSwarm - entry buildObjects \n",(int)self);)

   interfaceList = [List create: self];

   ruleMaker  = [RuleMaker  createBegin: self];
   [ruleMaker setLengthOfGenoma:     lengthOfGenoma];
   [ruleMaker setTurnoverRate:       turnoverRate];
   [ruleMaker setCrossoverRate:      crossoverRate];
   [ruleMaker setMutationRate:       mutationRate];
   [ruleMaker setEvolutionFrequency: evolutionFrequency];
   [ruleMaker setChildrenFitness:    childrenFitness];
   [ruleMaker setUseDeltaFitness:    useDeltaFitness];
   [ruleMaker setPopulationList:     interfaceList];
   ruleMaker  = [ruleMaker createEnd];

   for (i=0;i<numberOfInterfaces;i++)
   {

      anInterface = [Interface createBegin: self];
      [anInterface setLengthOfGenoma: lengthOfGenoma];
      anInterface = [anInterface createEnd];

      [interfaceList addLast: anInterface];

   }

TRACE2(printf("%8X ModelSwarm - exit buildObjects %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- buildActions
{

   // Create the list of simulation actions. We put these in an action
   // group, because we want these actions to be executed in a specific
   // order, but these steps should take no (simulated) time. The
   // M(foo) means "The message called <foo>". You can send a message
   // To a particular object, or ForEach object in a collection.

TRACE2(printf("\n%8X ModelSwarm - entry buildActions\n",(int) self);)

   modelActions = [ActionGroup create: self];
   [modelActions createActionForEach: interfaceList message: M(step)];
   [modelActions createActionTo:      ruleMaker     message: M(step)];

   // Then we create a schedule that executes the modelActions. modelActions
   // is an ActionGroup, by itself it has no notion of time. In order to
   // have it executed in time, we create a Schedule that says to use
   // the modelActions ActionGroup at particular times.
   // This schedule has a repeat interval of 1, it will loop every time step.
   // The action is executed at time 0 relative to the beginning of the loop.

   modelSchedule = [Schedule createBegin: self];
   [modelSchedule setRepeatInterval: 1];
   modelSchedule = [modelSchedule createEnd];
   [modelSchedule at: 0 createAction: modelActions];

TRACE2(printf("%8X ModelSwarm - exit buildActions %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- activateIn: swarmContext
{

   // Here, we activate the swarm in the context passed in
   // Then we activate our schedule in ourselves

TRACE2(printf("\n%8X ModelSwarm - entry activateIn\n",(int) self);)

   [super activateIn: swarmContext];
   [modelSchedule activateIn: self];

TRACE2(printf("%8X ModelSwarm - exit activateIn %8X\n\n",
              (int) self,(int) [self getSwarmActivity]);)

   return [self getSwarmActivity];

}

//--------------------------------------------------------------------

- print
{

TRACE2(printf("\n%8X ModelSwarm - entry print\n",(int) self);)

   [ruleMaker printStatistics];
   [interfaceList forEach: M(print)];

TRACE2(printf("%8X ModelSwarm - exit print %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------
@end
