// AgentProbaCamera.m


/*
static char Id="$Id: AgentProbaCamera.m,v 1.7 2000/02/27 18:22:57 mgd Exp $";
*/

#import "AgentProbaCamera.h"
#import <math.h>
#import <vision/TwoD.h>
#import <vision/ThreeD.h>
#import <random.h>

// Defining the methods for an Agent.
@implementation AgentProbaCamera

// Initialize crucial state for the agent.

-setWorlds: (id <Grid2d>) wAgt: (WorldObject *)wObj
{
  if (worldAgent != nil || worldObject != nil) {
    [InvalidArgument raiseEvent: "You can only set the worldAgent/worldObjects at once at creation time\n"];
  }
  worldAgent = wAgt;
  worldObject = wObj;

  return self;
}

// createEnd. This is a good place to put code that does various sorts
// of initialization that can only be done after some parameters of the
// object are set. It's also a good time to check for errors in creation.
-createEnd {
  // make sure the user set up worldAgent and worldObject.
  if (worldAgent == nil || worldObject == nil) {
    [InvalidCombination raiseEvent: "Agent was created without a worldAgent or worldObject.\n"];
  }

  worldXSize = [worldAgent getSizeX];
  worldYSize = [worldAgent getSizeY];

  return self;
}


-setX: (int) inX Y: (int) inY {
  x = inX;
  y = inY;
  [worldAgent putObject: self atX: x Y: y];
  return self;
}

-setCameraInit
{
  //int i;

  //builds camera and gives a couple of parameters

  camera = [Camera createBegin: [self getZone]]; // camera allocation
  camera = [camera createEnd];
  [camera initCamera: "EYE"]; // init parameters

  //printf("camera name: %s\n", [camera sendName]);
  //[[camera sendIntr] print]; // print these parameters
  //[[camera sendIntr] ViewAngle]; // give additional information such as view angle

  [[camera sendExtr] initialize: 0: 0: 0: 0];

  pixellist = [List create: [self getZone]];
  //printf("address pixellist is %d\n", pixellist);
  //[[camera sendExtr] print: [camera sendName]]; // print Extr parameters

  return self;
}

-(id)getCamera
{
  return camera;
}

-setAlpha: (float)a
{
  alpha=a;
  return self;
}

-(float)getAlpha
{
  return alpha;
}


-setRotAngle: (double)val
{
  rotAngle=val;
  return self;
}

-(double)getRotAngle
{
  return rotAngle;
}

-setNbPointSeen: (int)val
{
  nbPointSeen = val;
  return self;
}

-(int)getNbPointSeen
{
  return nbPointSeen;
}

-setNberOfRotOnSite: (int)val
{
  nberOfRotOnSite = val;
  return self;
}

-(int)getNberOfRotOnSite
{
  return nberOfRotOnSite;
}

-setCWCCWRotation:(int)val
{
  CWCCWRotation = val;
  return self;
}

-(int)getCWCCWRotation;
{
  return CWCCWRotation;
}

- setSeedDispl: (int)value
{
  seedValueAgt=value;
  //randGAgt = [[PMMLCG1gen alloc] initSeed: seedValueAgt];	  // seeds from clock
  //uRandAgt = [[[UniformIntegerDist alloc] init] setGenerator: randGAgt];
  //for the generator 
  randGAgt = [PMMLCG1gen createBegin: [self getZone]];
  [randGAgt setStateFromSeed: seedValueAgt];
  randGAgt = [randGAgt createEnd];
  // for the distribution
  uRandAgt = [UniformIntegerDist createBegin: [self getZone]];
  [uRandAgt setGenerator: randGAgt];
  uRandAgt = [uRandAgt createEnd];
  return self;
}

- setSeedCarrying: (int)value
{
  seedValueAgtOb = value;
  //randGAgtOb = [[PMMLCG1gen alloc] initSeed: seedValueAgtOb];	  // seeds from clock
  //uRandAgtOb = [[[UniformIntegerDist alloc] init] setGenerator: randGAgtOb];
  //for the generator 
  randGAgtOb = [PMMLCG1gen createBegin: [self getZone]];
  [randGAgtOb setStateFromSeed: seedValueAgtOb];
  randGAgtOb = [randGAgtOb createEnd];
  // for the distribution
  uRandAgtOb = [UniformIntegerDist createBegin: [self getZone]];
  [uRandAgtOb setGenerator: randGAgtOb];
  uRandAgtOb = [uRandAgtOb createEnd];
  return self;
}

- setSeedCCW: (int)value
{
  seedValueAgtCCW = value;
  //for the generator 
  randGAgtCCW = [PMMLCG1gen createBegin: [self getZone]];
  [randGAgtCCW setStateFromSeed: seedValueAgtCCW];
  randGAgtCCW = [randGAgtCCW createEnd];
  // for the distribution
  uRandAgtCCW = [UniformIntegerDist createBegin: [self getZone]];
  [uRandAgtCCW setGenerator: randGAgtCCW];
  uRandAgtCCW = [uRandAgtCCW createEnd];
  return self;
}

-(int)getSeedCCW
{
  return seedValueAgtCCW;
}


-(int)getSeedDispl
{
  return seedValueAgt;
}
-(int)getSeedCarrying
{
  return seedValueAgtOb;
}

-setCarriedObj:(int)value
{
  carriedObject=value;
  return self;
}

-(int)getCarriedObj
{
  return carriedObject;
}

// Agent behaviour is actually implemented here. The notion of a "step"
// method is a nice simplification for basic simulations.
-step {
  int newX, newY;
  int AgtState;
  int no;
  int i;
  double angle, rotation_angle, notused;
  int pixelseen=0;
  int smallest, i_smallest, distance;
  int intervalAngle;
  int val, tries;
  int rotation_counter;
  int boo, otherpercept, newx, newy;
  double rota_angle;

  // X world is Y of swarm world, Y world is virtual X of swarm (virtual height), Z world is Y swarm size - Y swarm
  // do not change the height x

  // update the camera coordinates with the position of the agent
  [[camera sendExtr] modifytheta: rotAngle]; // rotate clockwise
  [[camera sendExtr] modifyy: x];
  [[camera sendExtr] modifyz: y]; 
  //[[camera sendExtr] print: [camera sendName]]; // print Extr parameters

  // computes the images of the objects and returns the number of objects seen and the list of images
  pixelseen = [camera ComputeImage: [worldObject getThreeDList]: pixellist: [worldObject getStacks]: [worldAgent getSizeY]];
  [self setNbPointSeen: pixelseen];
  //printf("nber of objects seen : %d\n", pixelseen);

  // it has therefore no meaning to take an object on a cell wherein we dropped just before an object,
  // just because we are rotating (modification of our orientation).
  if ([self getNberOfRotOnSite]==0) { 
    AgtState = carriedObject;
    //val = [uRandAgtOb rMax: 100]; // random drawing between 0 and 99
    val = [uRandAgtOb getIntegerWithMin: 0L withMax: 100]; // between 0 and 100 included
    no = [worldObject getObjects: x: y];
    if ( no > 0) { // objects on the cell
      if (AgtState==0) { // potentially carrier
        if (val < (int)(100*pow((double)no, -(double)[self getAlpha]))) {	// we take the object
          carriedObject = 1;
          [self setAgtColor: 63]; // blue
          [worldObject RemoveObjects: -1: x: y];
        }
      } else if (AgtState == 1) {
        carriedObject = 0;
        [self setAgtColor: 64]; // green again
        [worldObject AddObjects: 1: x: y];
      }
    }

  } else {}

  // vision-based specific
  if (pixelseen == 0) {
    if ([self getNberOfRotOnSite]== 0) {
      // we proceed a random drawing: either clockwise or counterclockwise
      [self setCWCCWRotation: [uRandAgtCCW getIntegerWithMin: 0L withMax: 1]];
      //printf("%d\n",  [self getCWCCWRotation]);
    }
    // no object is seen, so just rotate clockwise or counter clockwise of PI_4 according to a random drawing
    if ([self getCWCCWRotation]) { // 0 CW, 1 CCW
      angle = PI_4;
    } else {
      angle = -PI_4;  
    }
  } else {
    smallest=1000;
    i_smallest=-1;
    for (i=0; i< pixelseen; i++) {
      //printf("pixel %d: u=%d, v=%d, size=%d\n", [[pixellist atOffset: i] sendlab], [[pixellist atOffset: i] sendu], 
      //	[[pixellist atOffset: i] sendv], [[pixellist atOffset: i] sendHeapHeight]);
      distance = [[pixellist atOffset: i] sendv] - [[camera sendIntr] sendv0];
      if (distance < 0) {
        distance = - distance;
      }
      if (smallest > distance) {
        smallest = distance;
        i_smallest = i; // we will go towards the object in front of us
      }
    }
    angle = atan2((double)([[pixellist atOffset: i_smallest] sendv]-[[camera sendIntr] sendv0]), (double)([[camera sendIntr] sendkv]*[[camera sendIntr] sendf]));  
    //printf("angle is %f (in degrees)\n", angle*180/M_PI);
  }

  intervalAngle = [self determinesIntervalAngle: [self getRotAngle]];

  if (pixelseen) {
    // computation of new coordinates for the displacement of the agent
    [self computesCoordAndOrien: intervalAngle: angle: &newX: &newY: &rotation_angle];
    [self setNberOfRotOnSite: 0];
    tries = 0;
    // we are checking if there is already another agent present in the location we plan to move to
    while ([worldAgent getObjectAtX: newX Y: newY] != nil && tries < 10) {
      // if yes, draw a random position, but keep the orientation as computed: explains why a rubbish
      // argument, i.e. notused is passed!
      [self RandomDrawingOnBoundGrid: &newX: &newY: &notused];
      tries++;	
    }
    if (tries == 10) {				 
      newX = x; // so just don't move.
      newY = y;
    }
  } else {
    // it seems only one stack remains: leave your cell to give a chance another agent to drop his object
    if ([self getNberOfRotOnSite] > 7) {
      [self RandomDrawingOnBoundGrid: &newX: &newY: &rotation_angle];
      tries = 0;
      // we are checking if there is already another agent present in the location we plan to move to
      while ([worldAgent getObjectAtX: newX Y: newY] != nil && tries < 10) {
        // if yes, draw a random position and a random orientation
        [self RandomDrawingOnBoundGrid: &newX: &newY: &rotation_angle];
        tries++;
      }
      if (tries == 10) {				 
        newX = x; // so just don't move.
        newY = y;
      }
    } else { // nothing is seen, continue rotating
      rotation_angle = rotAngle + angle;
      newX = x;
      newY = y;
      rotation_counter = [self getNberOfRotOnSite];
      rotation_counter +=1;
      [self setNberOfRotOnSite: rotation_counter];
    }
  }

  boo = [self neighbourhood: &newx: &newy: &rota_angle];
  if (boo){  // returns 0 if no object on neighbour cells, 1 if a neighbour
    newX = newx;
    newY = newy;
    rotation_angle = rota_angle;
    [self setNberOfRotOnSite: 0];
    otherpercept = 1; // we register it, because we already have computed the new coordinates to go to
  } else {
     otherpercept = 0; // we will use the vision to calculate the new coordinates
  }


  if (rotation_angle >= TwoPI) rotation_angle = rotation_angle - TwoPI;
  if (rotation_angle <= -TwoPI) rotation_angle = rotation_angle + TwoPI;

  // Now move ourselves in the grid and update our coordinates.
  [worldAgent putObject: nil atX: x Y: y];
  x = newX;
  y = newY;
  rotAngle = rotation_angle;
  //printf("move to x=%d, y=%d, rotation is %f\n", newX, newY, rotAngle);
  [worldAgent putObject: self atX: newX Y: newY];

  i=0;
  while (i++<pixelseen){
    [pixellist remove: [pixellist atOffset: 0]];
    //printf("removed %d \n", i);
  };

  // all done moving! Return self.
  return self;
}

// to convert into direction (0, ..., 7) the orientation
-(int)determinesIntervalAngle: (double)angle
{
  int intervalAng = 0;

  if (angle == 0) intervalAng = 0;
  if ((angle == PI_4)||(angle == -SevenPI_4)) intervalAng = 1;
  if ((angle == PI_2)||(angle == -ThreePI_2)) intervalAng = 2; 
  if ((angle == ThreePI_4)||(angle == -FivePI_4)) intervalAng = 3; 
  if ((angle == PI)||(angle == -PI)) intervalAng = 4; 
  if ((angle == -ThreePI_4)||(angle == FivePI_4)) intervalAng = 5;  
  if ((angle == -PI_2)||(angle == ThreePI_2)) intervalAng = 6;
  if ((angle == -PI_4)||(angle == SevenPI_4)) intervalAng = 7; 
  return (intervalAng);
}

// to convert the direction (0, ..., 7) into orientation
-(double)determinesAngle: (int)value
{
  double angle = 0.0;

  if (value == 0) angle=0;
  if (value == 1) angle = PI_4;
  if (value == 2) angle = PI_2;
  if (value == 3) angle = ThreePI_4;
  if (value == 4) angle = PI;
  if (value == 5) angle = FivePI_4;
  if (value == 6) angle = ThreePI_2;
  if (value == 7) angle = SevenPI_4;
  return (angle);
}

// computation of new coordinates for the displacement of the agent
-computesCoordAndOrien: (int)intervalAng: (double)angle: (int *)new_x: (int *)new_y: (double *)rotation_angle
{
  switch(intervalAng) {
    case 0:
      if (angle <= -PI_8) {
        *rotation_angle = [self getRotAngle] - PI_4;
	*new_x = x-1;
	*new_y = y-1;
      } else if ((-PI_8 < angle) && (angle < PI_8)) {
        *rotation_angle = [self getRotAngle];
	*new_x = x;
        *new_y = y-1;
      } else if (angle >= PI_8) {
        *rotation_angle =  [self getRotAngle] + PI_4;
	*new_x = x+1;
	*new_y = y-1;
      }  
      break;
    case 1:
      if (angle <= -PI_8) {
        *rotation_angle = [self getRotAngle] - PI_4;
	*new_x = x;
	*new_y = y-1;
      } else if ((-PI_8 < angle) && (angle < PI_8)) {
        *rotation_angle = [self getRotAngle];
	*new_x = x+1;
	*new_y = y-1;
      } else if (angle >= PI_8) {
        *rotation_angle = [self getRotAngle] + PI_4;
	*new_x = x+1;
	*new_y = y;
      }     
      break;
    case 2:
      if (angle <= -PI_8) {
        *rotation_angle = [self getRotAngle] - PI_4;
	*new_x = x+1;
	*new_y = y-1;
      } else if ((-PI_8 < angle) && (angle < PI_8)) {
        *rotation_angle = [self getRotAngle];
	*new_x = x+1;
	*new_y = y;
      } else if (angle >= PI_8) {
        *rotation_angle = [self getRotAngle] + PI_4;
	*new_x = x+1;
 	*new_y = y+1;
      }     
      break;
    case 3:
      if (angle <= -PI_8) {
        *rotation_angle = [self getRotAngle] - PI_4;
	*new_x = x+1;
 	*new_y = y;
      } else if ((-PI_8 < angle) && (angle < PI_8)) {
        *rotation_angle = [self getRotAngle];
	*new_x = x+1;
	*new_y = y+1;
      } else if (angle >= PI_8) {
        *rotation_angle = [self getRotAngle] + PI_4;
	*new_x = x;
	*new_y = y+1;
      }     
      break;
    case 4:
      if (angle <= -PI_8) {
        *rotation_angle = [self getRotAngle] - PI_4;
	*new_x = x+1;
	*new_y = y+1;
      } else if ((-PI_8 < angle) && (angle < PI_8)) {
        *rotation_angle = [self getRotAngle];
	*new_x = x;
	*new_y = y+1;
      } else if (angle >= PI_8) {
        *rotation_angle = [self getRotAngle] + PI_4;
 	*new_x = x-1;
	*new_y = y+1;
      }
      break;
    case 5:
      if (angle <= -PI_8) {
        *rotation_angle = [self getRotAngle] - PI_4;
	*new_x = x;
	*new_y = y+1;
      } else if ((-PI_8 < angle) && (angle < PI_8)) {
        *rotation_angle = [self getRotAngle];
	*new_x = x-1;
	*new_y = y+1;
      } else if (angle >= PI_8) {
        *rotation_angle = [self getRotAngle] + PI_4;
	*new_x = x-1;
	*new_y = y;
      }
      break;
    case 6:
      if (angle <= -PI_8) {
        *rotation_angle = [self getRotAngle] - PI_4;
	*new_x = x-1;
	*new_y = y+1;
      } else if ((-PI_8 < angle) && (angle < PI_8)) {
        *rotation_angle = [self getRotAngle];
	*new_x = x-1;
	*new_y = y;
      } else if (angle >= PI_8) {
        *rotation_angle = [self getRotAngle] + PI_4;
	*new_x = x-1;
	*new_y = y-1;
      }
      break;
    case 7:
      if (angle <= -PI_8) {
        *rotation_angle = [self getRotAngle] - PI_4;
	*new_x = x-1;
	*new_y = y;
      } else if ((-PI_8 < angle) && (angle < PI_8)) {
        *rotation_angle = [self getRotAngle];
	*new_x = x-1;
	*new_y = y-1;
      } else if (angle >= PI_8) {
        *rotation_angle = 0; // in fact: rotAngle + PI_4, that is, TwoPI which is equivalent to 0.
	*new_x = x;
	*new_y = y-1;
      }
      break;
    default:
      break;
    }
    return self;
}

-randomChoice: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle
{
  int val;
   
  //val = [uRandAgt rMax: bound]; // we choose the cell randomly, but we keep the rotation as computed
  val = [uRandAgt getIntegerWithMin: 0L withMax: bound]; //random drawing between 0 and bound
  switch(val) {
    case 0:
      *new_x = x;
      *new_y = y-1;
      *rotation_angle = 0;
      break;
    case 1:
      *new_x = x+1;
      *new_y = y-1;
      *rotation_angle = PI_4;
      break;
    case 2:
      *new_x = x+1;
      *new_y = y;
      *rotation_angle = PI_2;
      break;
    case 3:
      *new_x = x+1;
      *new_y = y+1;
      *rotation_angle = ThreePI_4;
      break;
    case 4:
      *new_x = x;
      *new_y = y+1;
      *rotation_angle = PI;
      break;
    case 5:
      *new_x = x-1;
      *new_y = y+1;
      *rotation_angle = FivePI_4;
      break;
    case 6:
      *new_x = x-1;
      *new_y = y;
      *rotation_angle = ThreePI_2;
      break;
    case 7:
      *new_x = x-1;
      *new_y = y-1;
      *rotation_angle = SevenPI_4;
      break;
    default:
      break; 
  }
  //*new_x = (*new_x + worldXSize) % worldXSize;	  // normalize coords if a torus grid
  //*new_y = (*new_y + worldYSize) % worldYSize;
  return self; 
}

-randomChoiceUpLeftCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle
{
  int val;
   
  //val = [uRandAgt rMax: bound]; // we choose the cell randomly, but we keep the rotation as computed
  val = [uRandAgt getIntegerWithMin: 0L withMax: bound]; //random drawing between 0 and bound
  switch(val) {
    case 0:
      *new_x = x+1;
      *new_y = y;
      *rotation_angle = PI_2;
      break;
    case 1:
      *new_x = x+1;
      *new_y = y+1;
      *rotation_angle = ThreePI_4;
      break;
    case 2:
      *new_x = x;
      *new_y = y+1;
      *rotation_angle = PI;
      break;
    default:
      break; 
  }
  return self;
}

-randomChoiceLoLeftCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle
{
  int val;
   
  //val = [uRandAgt rMax: bound]; // we choose the cell randomly, but we keep the rotation as computed
  val = [uRandAgt getIntegerWithMin: 0L withMax: bound]; //random drawing between 0 and bound
  switch(val) {
    case 0:
      *new_x = x;
      *new_y = y-1;
      *rotation_angle = 0;
      break;
    case 1:
      *new_x = x+1;
      *new_y = y-1;
      *rotation_angle = PI_4;
      break;
    case 2:
      *new_x = x+1;
      *new_y = y;
      *rotation_angle = PI_2;
      break;
    default:
      break; 
  }
  return self;
}

-randomChoiceLeftBorder: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle
{
  int val;
   
  //val = [uRandAgt rMax: bound]; // we choose the cell randomly, but we keep the rotation as computed
  val = [uRandAgt getIntegerWithMin: 0L withMax: bound]; //random drawing between 0 and bound
  switch(val) {
    case 0:
      *new_x = x;
      *new_y = y-1;
      *rotation_angle = 0;
      break;
    case 1:
      *new_x = x+1;
      *new_y = y-1;
      *rotation_angle = PI_4;
      break;
    case 2:
      *new_x = x+1;
      *new_y = y;
      *rotation_angle = PI_2;
      break;
    case 3:
      *new_x = x+1;
      *new_y = y+1;
      *rotation_angle = ThreePI_4;
      break;
    case 4:
      *new_x = x;
      *new_y = y+1;
      *rotation_angle = PI;
      break;
    default:
      break; 
  }
  return self;
}
      
-randomChoiceUpRightCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle
{
  int val;
   
  //val = [uRandAgt rMax: bound]; // we choose the cell randomly, but we keep the rotation as computed
  val = [uRandAgt getIntegerWithMin: 0L withMax: bound]; //random drawing between 0 and bound
  switch(val) {
    case 0:
      *new_x = x;
      *new_y = y+1;
      *rotation_angle = PI;
      break;
    case 1:
      *new_x = x-1;
      *new_y = y+1;
      *rotation_angle = FivePI_4;
      break;
    case 2:
      *new_x = x-1;
      *new_y = y;
      *rotation_angle = ThreePI_2;
      break;
    default:
      break; 
  }
  return self;
}

-randomChoiceLoRightCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle
{
  int val;
   
  //val = [uRandAgt rMax: bound]; // we choose the cell randomly, but we keep the rotation as computed
  val = [uRandAgt getIntegerWithMin: 0L withMax: bound]; //random drawing between 0 and bound
  switch(val) {
    case 0:
      *new_x = x;
      *new_y = y-1;
      *rotation_angle = 0;
      break;
    case 1:
      *new_x = x-1;
      *new_y = y;
      *rotation_angle = ThreePI_2;
      break;
    case 2:
      *new_x = x-1;
      *new_y = y-1;
      *rotation_angle = SevenPI_4;
      break;
    default:
      break; 
  }
  return self;
}

-randomChoiceRightBorder: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle
{
  int val;
   
  //val = [uRandAgt rMax: bound]; // we choose the cell randomly, but we keep the rotation as computed
  val = [uRandAgt getIntegerWithMin: 0L withMax: bound]; //random drawing between 0 and bound
  switch(val) {
    case 0:
      *new_x = x;
      *new_y = y-1;
      *rotation_angle = 0;
      break;
    case 1:
      *new_x = x;
      *new_y = y+1;
      *rotation_angle = PI;
      break;
    case 2:
      *new_x = x-1;
      *new_y = y+1;
      *rotation_angle = FivePI_4;
      break;
    case 3:
      *new_x = x-1;
      *new_y = y;
      *rotation_angle = ThreePI_2;
      break;
    case 4:
      *new_x = x-1;
      *new_y = y-1;
      *rotation_angle = SevenPI_4;
      break;
    default:
      break; 
  }
  return self;
}

-randomChoiceUpRow: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle
{
  int val;
   
  //val = [uRandAgt rMax: bound]; // we choose the cell randomly, but we keep the rotation as computed
  val = [uRandAgt getIntegerWithMin: 0L withMax: bound]; //random drawing between 0 and bound
  switch(val) {
    case 0:
      *new_x = x+1;
      *new_y = y;
      *rotation_angle = PI_2;
      break;
    case 1:
      *new_x = x+1;
      *new_y = y+1;
      *rotation_angle = ThreePI_4;
      break;
    case 2:
      *new_x = x;
      *new_y = y+1;
      *rotation_angle = PI;
      break;
    case 3:
      *new_x = x-1;
      *new_y = y+1;
      *rotation_angle = FivePI_4;
      break;
    case 4:
      *new_x = x-1;
      *new_y = y;
      *rotation_angle = ThreePI_2;
      break;
    default:
      break; 
  }
  return self;
}
    
-randomChoiceLoRow: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle
{
  int val;
   
  //val = [uRandAgt rMax: bound]; // we choose the cell randomly, but we keep the rotation as computed
  val = [uRandAgt getIntegerWithMin: 0L withMax: bound]; //random drawing between 0 and bound
  switch(val) {
    case 0:
      *new_x = x;
      *new_y = y-1;
      *rotation_angle = 0;
      break;
    case 1:
      *new_x = x+1;
      *new_y = y-1;
      *rotation_angle = PI_4;
      break;
    case 2:
      *new_x = x+1;
      *new_y = y;
      *rotation_angle = PI_2;
      break;
    case 3:
      *new_x = x-1;
      *new_y = y;
      *rotation_angle = ThreePI_2;
      break;
    case 4:
      *new_x = x-1;
      *new_y = y-1;
      *rotation_angle = SevenPI_4;
      break;
    default:
      break; 
  }
  return self;
}

-RandomDrawingOnBoundGrid: (int *)newx: (int *)newy: (double *)rotation_angle
{
  int bound;
      
  if ((x == 0) && (y == 0)) { // upper left corner
    bound = 2; // three neighbour cells to possibly move to
    [self randomChoiceUpLeftCorner: bound: newx: newy: rotation_angle];
  } else if ((x == 0) && (y == worldYSize - 1)) {  // lower left corner
    bound = 2; // three neighbour cells to possibly move to
    [self randomChoiceLoLeftCorner: bound: newx: newy: rotation_angle];
  } else if ((x == 0) && (y != 0)  && (y != worldYSize - 1))  { // left border, corners excepted
    bound = 4; // five neighbour cells to possibly move to
    [self randomChoiceLeftBorder: bound: newx: newy: rotation_angle];
  } else if ((x == worldXSize - 1) && (y == 0)) {  // upper right corner
    bound = 2; // three neighbour cells to possibly move to
    [self randomChoiceUpRightCorner: bound: newx: newy: rotation_angle];
  } else if ((x == worldXSize - 1) && (y == worldYSize - 1)) { // lower rigth corner
    bound = 2; // three neighbour cells to possibly move to
    [self randomChoiceLoRightCorner: bound: newx: newy: rotation_angle];
  } else if ((x == worldXSize - 1) && (y != 0)  && (y != worldYSize - 1)) {  //right border, corners excepted
    bound = 4; // five neighbour cells to possibly move to
    [self randomChoiceRightBorder: bound: newx: newy: rotation_angle];
  } else if ((y == 0) && (x != 0) && (x != worldXSize - 1)) {   // upper row, corners excepted
    bound = 4; // five neighbour cells to possibly move to
    [self randomChoiceUpRow: bound: newx: newy: rotation_angle];
  } else if ((y == worldYSize - 1) && (x != 0) && (x != worldXSize - 1)) {  // lower row, corners excepted
    bound = 4; // five neighbour cells to possibly move to
    [self randomChoiceLoRow: bound: newx: newy: rotation_angle];
  } else { // eight neighbour cells to possibly move to
    bound = 7;
    [self randomChoice: bound: newx: newy: rotation_angle];
  }
  return self;
}

-(int)neighbourhood: (int *)newx: (int *)newy: (double *)rotation_angle
{
  int direction, locationOnGrid;
  int aligned_cell, left_cell, right_cell;
  int percept=0;
  int x_center, y_center, x_left, y_left, x_right, y_right;

  locationOnGrid = [self calculateLocation]; // to determine where we are exactely!
  //printf("position is %d\n", locationOnGrid);

  direction = [self determinesIntervalAngle: [self getRotAngle]]; // Our orientation on the grid
  //printf("direction is %d\n", direction);

  switch (direction) {
    case 0:
      x_center = x; y_center = y-1;
      x_left = x-1; y_left = y-1;
      x_right = x+1; y_right = y-1;
      switch (locationOnGrid) {
        case 0: // we are in the middle of the grid
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = 0; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = SevenPI_4; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 1: // upper left corner
          percept = 0;
          break;
        case 2: // lower left corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = 0; percept = 1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 3: // we are on the left border
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = 0; percept = 1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 4: // upper right corner
          percept = 0;
          break;
        case 5: // right bottom corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = 0; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = SevenPI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 6: // right border
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = 0; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = SevenPI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 7: // uppermost row
          percept = 0;
          break;
        case 8: // lowest row
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = 0; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = SevenPI_4; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        default:
          break;
      }
      break;
    case 1:
      x_center = x+1; y_center = y-1;
      x_left = x; y_left = y-1;
      x_right = x+1; y_right = y;
      switch (locationOnGrid) {
        case 0: // we are in the middle of the grid
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = 0; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 1: // upper left corner
          if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 2: // lower left corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = 0; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 3: // we are on the left border
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = 0; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 4: // upper right corner
          percept = 0;
          break;
        case 5: // right bottom corner
         if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = 0; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 6: // right border
         if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = 0; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 7: // uppermost row
          if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 8: // lowest row
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = 0; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        default:
          break;
      }
      break;
    case 2:
      x_center = x+1; y_center = y;
      x_left = x+1; y_left = y-1;
      x_right = x+1; y_right = y+1;
      switch (locationOnGrid) {
        case 0: // we are in the middle of the grid
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI_2; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI_4; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = ThreePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 1: // upper left corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI_2; percept = 1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = ThreePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 2: // lower left corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI_2; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 3: // we are on the left border
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI_2; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI_4; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = ThreePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 4: // upper right corner
          percept = 0;
          break;
        case 5: // right bottom corner
          percept = 0;
          break;
        case 6: // right border
          percept = 0;
          break;
        case 7: // uppermost row
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI_2; percept = 1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = ThreePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 8: // lowest row
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI_2; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        default:
          break;
      }
      break;
    case 3:
      x_center = x+1; y_center = y+1;
      x_left = x+1; y_left = y;
      x_right = x; y_right = y+1;
      switch (locationOnGrid) {
        case 0: // we are in the middle of the grid
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = ThreePI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI_2; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 1: // upper left corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = ThreePI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI_2; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 2: // lower left corner
          if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 3: // we are on the left border
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = ThreePI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI_2; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 4: // upper right corner
          if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 5: // right bottom corner
          percept = 0;
          break;
        case 6: // right border
          if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 7: // uppermost row
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = ThreePI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI_2; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = PI; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 8: // lowest row
          if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        default:
          break;
      }
      break;
    case 4:
      x_center = x; y_center = y+1;
      x_left = x+1; y_left = y+1;
      x_right = x-1; y_right = y+1;
      switch (locationOnGrid) {
        case 0: // we are in the middle of the grid
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = ThreePI_4; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = FivePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 1: // upper left corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = ThreePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 2: // lower left corner
          percept = 0;
          break;
        case 3: // we are on the left border
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = ThreePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 4: // upper right corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI; percept = 1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = FivePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 5: // right bottom corner
          percept = 0;
          break;
        case 6: // right border
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI; percept = 1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = FivePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 7: // uppermost row
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = PI; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = ThreePI_4; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = FivePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 8: // lowest row
          percept = 0;
          break;
        default:
          break;
      }
      break;
    case 5:
      x_center = x-1; y_center = y+1;
      x_left = x; y_left = y+1;
      x_right = x-1; y_right = y;
      switch (locationOnGrid) {
        case 0: // we are in the middle of the grid
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = FivePI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = ThreePI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 1: // upper left corner
          if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 2: // lower left corner
          percept = 0;
          break;
        case 3: // we are on the left border
          if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 4: // upper right corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = FivePI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = ThreePI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 5: // right bottom corner
          if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = ThreePI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 6: // right border
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = FivePI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = ThreePI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 7: // uppermost row
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = FivePI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = PI; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = ThreePI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 8: // lowest row
          if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = ThreePI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        default:
          break;
      }
      break;
    case 6:
      x_center = x-1; y_center = y;
      x_left = x-1; y_left = y+1;
      x_right = x-1; y_right = y-1;
      switch (locationOnGrid) {
        case 0: // we are in the middle of the grid
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = ThreePI_2; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = FivePI_4; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = SevenPI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 1: // upper left corner
          percept = 0;
          break;
        case 2: // lower left corner
          percept = 0;
          break;
        case 3: // we are on the left border
          percept = 0;
          break;
        case 4: // upper right corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = ThreePI_2; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = FivePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 5: // right bottom corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = ThreePI_2; percept = 1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = SevenPI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 6: // right border
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = ThreePI_2; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = FivePI_4; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = SevenPI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 7: // uppermost row
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = ThreePI_2; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = FivePI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 8: // lowest row
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = ThreePI_2; percept = 1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = SevenPI_4; percept =1;
          } else {
            percept = 0;
          }
          break;
        default:
          break;
      }
      break;
    case 7:
      x_center = x-1; y_center = y-1;
      x_left = x-1; y_left = y;
      x_right = x; y_right = y-1;
      switch (locationOnGrid) {
        case 0: // we are in the middle of the grid
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = SevenPI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = ThreePI_2; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = 0; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 1: // upper left corner
          percept = 0;
          break;
        case 2: // lower left corner
          if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = 0; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 3: // we are on the left border
          if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = 0; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 4: // upper right corner
          if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = ThreePI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 5: // right bottom corner
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = SevenPI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = ThreePI_2; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = 0; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 6: // right border
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = SevenPI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = ThreePI_2; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = 0; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 7: // uppermost row
          if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = ThreePI_2; percept =1;
          } else {
            percept = 0;
          }
          break;
        case 8: // lowest row
          if ((aligned_cell=[worldObject getObjects: x_center: y_center]) && ([worldAgent getObjectAtX: x_center Y: y_center] == nil)){
            *newx = x_center; *newy = y_center; *rotation_angle = SevenPI_4; percept = 1;
          } else if ((left_cell = [worldObject getObjects: x_left: y_left]) && ([worldAgent getObjectAtX: x_left Y: y_left] == nil)){
            *newx = x_left; *newy = y_left; *rotation_angle = ThreePI_2; percept =1;
          } else if ((right_cell = [worldObject getObjects: x_right: y_right]) && ([worldAgent getObjectAtX: x_right Y: y_right] == nil)){
            *newx = x_right; *newy = y_right; *rotation_angle = 0; percept =1;
          } else {
            percept = 0;
          }
          break;
        default:
          break;
      }
      break;
    default:
      break;
  }
  return percept;
}

-(int)calculateLocation
{
  int location;

  if ((x == 0) && (y == 0)) { // upper left corner
    location = 1;
  } else if ((x == 0) && (y == worldYSize - 1)) {  // lower left corner
    location = 2;
  } else if ((x == 0) && (y != 0)  && (y != worldYSize - 1))  { // left border, corners excepted
    location = 3;
  } else if ((x == worldXSize - 1) && (y == 0)) {  // upper right corner
    location = 4;
  } else if ((x == worldXSize - 1) && (y == worldYSize - 1)) { // lower rigth corner
    location = 5;
  } else if ((x == worldXSize - 1) && (y != 0)  && (y != worldYSize - 1)) {  //right border, corners excepted
    location = 6;
  } else if ((y == 0) && (x != 0) && (x != worldXSize - 1)) {   // upper row, corners excepted
    location = 7;
  } else if ((y == worldYSize - 1) && (x != 0) && (x != worldXSize - 1)) {  // lower row, corners excepted
    location = 8;
  } else { // eight neighbour cells to possibly move to
    location = 0;
  }
  return location;
}

// Extra bits of display code: setting our colour, drawing on a window.
// This code works, but it'd be better if there were a generic object
// that knew how to draw agents on grids.
-setAgtColor: (Color) c {
  agtColor = c;
  return self;
}

- drawSelfOn: (id <Raster>)r 
{
  [r drawPointX: x Y: y Color: agtColor];
  return self;
}

@end


/*
$Log: AgentProbaCamera.m,v $
Revision 1.7  2000/02/27 18:22:57  mgd
*** empty log message ***

Revision 1.5  1998/04/24 21:19:13  mgd
Revert WorldObject protocol things.

Revision 1.4  1998/04/24 01:52:46  mgd
* WorldObject.m: Include collections.h.

* WorldObject.h: Include space/Discrete2d.h.  Add a WorldObject
protocol.

* Stack.h: Include objectbase/SwarmObject.h instead of objectbase.h.

* AgentProbaCamera.h: Include objectbase/SwarmObject.h instead of
objectbase.h.
(AgentProbaCamera): Make worldAgent conform to the Grid2d protocol.

* AgentProbaCamera.[hm]:
Make setWorlds:wAgt: first argument conform to Grid2d protocol,
and second conform to the WorldObject protocol.

* AgentObserverSwarm.h (AgentObserverSwarm): Make envDisplay
conform to the Value2dDisplay protocol.  Make agentDisplay
conform to the Object2dDisplay protocol.

* AgentModelSwarm.h: Include objectbase/Swarm.h instead of
objectbase.h.  Make worldAgent an object conforming to the
Grid2d protocol, likewise for getter.  Make worldObject an
object conforming to the WorldObject protocol, likewise for getter.

Revision 1.3  1998/02/28 08:47:19  mgd
* AgentProbaCamera.m: Include random.h instead of simtools.h.

* WorldObject.m: Likewise.

* AgentObserverSwarm.h: Don't include objectbase.h, space.h,
activity.h, gui.h, collections.h, or simtools.h.  Include
simtoolsgui/GUISwarm.h and simtoolsgui.h.

* AgentModelSwarm.m: Include random.h instead of simtools.h.

Revision 1.2  1998/02/04 01:08:07  mgd
* main.m (main): Constify argv.

* WorldObject.m ([WorldObject -RemoveObjects:::]): Initialize
oldsize and newsize to avoid warning.

* Stack.h: Include objectbase.h instead of swarmobject.h.

* Makefile (APPLIBS): Remove -lneuro and -lga.

* AgentProbaCamera.m ([AgentProbaCamera -determinesIntervalAngle:]):
Initialize intervalAng to avoid warning.
([AgentProbaCamera -determinesAngle:]):
Initialize angle to avoid warning.
([AgentProbaCamera -drawSelfOn:]): Make argument to drawSelfOn:
an id <Raster> instead of being statically typed.

* AgentProbaCamera.h:  Include objectbase.h and gui.h
instead of swarmobject.h and tkobjc/Raster.h.
([-drawSelfOn:r]): Make argument to drawSelfOn: an id <Raster>
instead of being statically typed.

* AgentObserverSwarm.m: Include objectbase.h instead of
swarmobject.h.  Constify StackColors and descr.  Include
simtools.h and gui.h.
(-convert::): Initialize j to avoid warning.
([AgentObserverSwarm +createBegin:]): Make probeMap comply with
the ProbeMap protocol rather than being statically typed.
([AgentObserverSwarm -buildObjects]): Use
CREATE_ARCHIVED_PROBE_DISPLAY for agentModelSwarm and
AgentObserverSwarm.  Send waitForControlEvent to actionCache
rather than controlPanel.  Create colormap from Colormap instead
of XColormap. Use setDisplayWidget:colormap: rather than
setDisplayWidget:Colormap:.  Create StackGraph from Graph instead
of BLTGraph. Use renamed setTitle: and setAxisLabelX:Y:.  Likewise
for BiggestStackGraph and useHisto.
([AgentObserverSwarm -updateHisto]): Use renamed
drawHistogramWithInt:.

* AgentObserverSwarm.h: Include gui.h instead of tkobjc.h.
Include objectbase.h instead of swarmobject.h.
(AgentObserverSwarm): Make colormap comply with the Colormap
protocol instead of being statically typed to XColormap.
Make worldRaster comply with the ZoomRaster protocol instead of
being statically typed.  Make StackGraph and BiggestStackGraph
comply with the Graph protocol instead of being statically
typed to BLTGraph.  Make StackData and BiggestStackData comply
with the GraphElement protocol instead of being statically typed.
Make StackGrapher and BiggestStackGrapher comply with the
ActiveGraph protocol instead of being statically typed.  Make
useHisto comply with the Histogram protocol instead of being
statically typed to Histo.

* AgentModelSwarm.m ([AgentModelSwarm -convert::]): Initialize
j to avoid warning.
([AgentModelSwarm +createBegin:]): Use id <ProbeMap> instead of
statically typing probeMap.

* AgentModelSwarm.h: Change swarmobject.h to objectbase.h.

Revision 1.1.1.1  1998/02/03 23:40:03  mgd
EnhApp import

Revision 1.2  1997/04/02 09:24:10  chantem
can now choose to rotate counter clockwise or clockwise

Revision 1.1  1997/04/02 09:00:08  chantem
Initial revision

Revision 1.1  1997/03/25 12:40:14  chantem
Initial revision

*/
