
// AgentProbaCamera.h


/*
static char Id="$Id: AgentProbaCamera.h,v 1.4 1998/04/24 21:19:12 mgd Exp $"
*/


#import <objectbase/SwarmObject.h>
#import <gui.h>
#import <space.h>
#import "WorldObject.h" // we also have a WorldObject object
#import <vision/Camera.h>
#import <vision/TwoD.h>

#define PI M_PI
#define TwoPI 2*M_PI
#define PI_4 M_PI/4
#define PI_2 M_PI/2
#define ThreePI_2 3*M_PI/2
#define ThreePI_4 3*M_PI/4
#define FivePI_4 5*M_PI/4
#define SevenPI_4 7*M_PI/4
#define PI_8 M_PI/8

// We inherit code from the generic SwarmObject, which provides memory
// allocation and other niceties.

@interface AgentProbaCamera: SwarmObject
{
  int x, y; // my spatial coordinates
  float alpha;
  int carriedObject;
  double rotAngle;
  id <Grid2d> worldAgent; // the world agents live in
  int worldXSize, worldYSize; // how big that world is
  WorldObject *worldObject;// the world containing objects
  Color agtColor; // my colour (display)
  id randGAgt; // my own random generator for displacements
  id uRandAgt;
  int seedValueAgt;
  id randGAgtOb; // my own random generator for deciding to take an object or not
  id uRandAgtOb;
  int seedValueAgtOb;
  id randGAgtCCW; // my own random generator for deciding clockwise or counterclockwise rotating
  id uRandAgtCCW;
  int seedValueAgtCCW;
  id pixellist; // list of 2D points
  Camera *camera;
  int nbPointSeen;
  int nberOfRotOnSite;
  int CWCCWRotation; // to choose between clockwise or conterclock: not used now, but in a short time
}

-setWorlds: (id <Grid2d>)wAgt: (WorldObject *)wObj; // which world are we in?
-createEnd;

-setX: (int) x Y: (int) y; // agt's position
-setRotAngle: (double)val;
-(double)getRotAngle;
-setCameraInit;

-(id)getCamera;

-setAgtColor: (Color) c; // agt's colour (display)

-setAlpha: (float)a;
-(float)getAlpha;
-setNbPointSeen: (int)val;
-(int)getNbPointSeen;

-setNberOfRotOnSite: (int)val;
-(int)getNberOfRotOnSite;
-setCWCCWRotation:(int)val;
-(int)getCWCCWRotation;
-setSeedDispl: (int)value;
-setSeedCarrying: (int)value;
-(int)getSeedDispl;
-(int)getSeedCarrying;
-setSeedCCW: (int)value;
-(int)getSeedCCW;
-setCarriedObj:(int)value;
-(int)getCarriedObj;

// The major agent behaviour: do one "time step" (all agt action).
-step;

// to convert into direction (0, ..., 7) the orientation
-(int)determinesIntervalAngle: (double)angle;
-(double)determinesAngle: (int)value;

// computation of new coordinates for the displacement of the agent
-computesCoordAndOrien: (int)intervalAng: (double)angle: (int *)new_x: (int *)new_y: (double *)rotation_angle;

// draws randomly new coordinates and new orientation versus the bound (upper limit):
// example: bound = 4 means, random drawing in integer 0, 1, 2, 3
-randomChoice: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;

-randomChoiceUpLeftCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceLoLeftCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceLeftBorder: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceUpRightCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceLoRightCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceRightBorder: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceUpRow: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceLoRow: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;

-RandomDrawingOnBoundGrid: (int *)newx: (int *)newy: (double *)rotation_angle;

-(int)neighbourhood:(int *)new_x: (int *)new_y: (double *)rotation_angle;
-(int)calculateLocation;

// extra display code (agents currently draw themselves)
-drawSelfOn: (id <Raster>) r;

@end

/*
$Log: AgentProbaCamera.h,v $
Revision 1.4  1998/04/24 21:19:12  mgd
Revert WorldObject protocol things.

Revision 1.3  1998/04/24 01:52:46  mgd
* WorldObject.m: Include collections.h.

* WorldObject.h: Include space/Discrete2d.h.  Add a WorldObject
protocol.

* Stack.h: Include objectbase/SwarmObject.h instead of objectbase.h.

* AgentProbaCamera.h: Include objectbase/SwarmObject.h instead of
objectbase.h.
(AgentProbaCamera): Make worldAgent conform to the Grid2d protocol.

* AgentProbaCamera.[hm]:
Make setWorlds:wAgt: first argument conform to Grid2d protocol,
and second conform to the WorldObject protocol.

* AgentObserverSwarm.h (AgentObserverSwarm): Make envDisplay
conform to the Value2dDisplay protocol.  Make agentDisplay
conform to the Object2dDisplay protocol.

* AgentModelSwarm.h: Include objectbase/Swarm.h instead of
objectbase.h.  Make worldAgent an object conforming to the
Grid2d protocol, likewise for getter.  Make worldObject an
object conforming to the WorldObject protocol, likewise for getter.

Revision 1.2  1998/02/04 01:08:07  mgd
* main.m (main): Constify argv.

* WorldObject.m ([WorldObject -RemoveObjects:::]): Initialize
oldsize and newsize to avoid warning.

* Stack.h: Include objectbase.h instead of swarmobject.h.

* Makefile (APPLIBS): Remove -lneuro and -lga.

* AgentProbaCamera.m ([AgentProbaCamera -determinesIntervalAngle:]):
Initialize intervalAng to avoid warning.
([AgentProbaCamera -determinesAngle:]):
Initialize angle to avoid warning.
([AgentProbaCamera -drawSelfOn:]): Make argument to drawSelfOn:
an id <Raster> instead of being statically typed.

* AgentProbaCamera.h:  Include objectbase.h and gui.h
instead of swarmobject.h and tkobjc/Raster.h.
([-drawSelfOn:r]): Make argument to drawSelfOn: an id <Raster>
instead of being statically typed.

* AgentObserverSwarm.m: Include objectbase.h instead of
swarmobject.h.  Constify StackColors and descr.  Include
simtools.h and gui.h.
(-convert::): Initialize j to avoid warning.
([AgentObserverSwarm +createBegin:]): Make probeMap comply with
the ProbeMap protocol rather than being statically typed.
([AgentObserverSwarm -buildObjects]): Use
CREATE_ARCHIVED_PROBE_DISPLAY for agentModelSwarm and
AgentObserverSwarm.  Send waitForControlEvent to actionCache
rather than controlPanel.  Create colormap from Colormap instead
of XColormap. Use setDisplayWidget:colormap: rather than
setDisplayWidget:Colormap:.  Create StackGraph from Graph instead
of BLTGraph. Use renamed setTitle: and setAxisLabelX:Y:.  Likewise
for BiggestStackGraph and useHisto.
([AgentObserverSwarm -updateHisto]): Use renamed
drawHistogramWithInt:.

* AgentObserverSwarm.h: Include gui.h instead of tkobjc.h.
Include objectbase.h instead of swarmobject.h.
(AgentObserverSwarm): Make colormap comply with the Colormap
protocol instead of being statically typed to XColormap.
Make worldRaster comply with the ZoomRaster protocol instead of
being statically typed.  Make StackGraph and BiggestStackGraph
comply with the Graph protocol instead of being statically
typed to BLTGraph.  Make StackData and BiggestStackData comply
with the GraphElement protocol instead of being statically typed.
Make StackGrapher and BiggestStackGrapher comply with the
ActiveGraph protocol instead of being statically typed.  Make
useHisto comply with the Histogram protocol instead of being
statically typed to Histo.

* AgentModelSwarm.m ([AgentModelSwarm -convert::]): Initialize
j to avoid warning.
([AgentModelSwarm +createBegin:]): Use id <ProbeMap> instead of
statically typing probeMap.

* AgentModelSwarm.h: Change swarmobject.h to objectbase.h.

Revision 1.1.1.1  1998/02/03 23:40:03  mgd
EnhApp import

Revision 1.2  1997/04/02 09:23:40  chantem
can no choose to rotate counter clockwise or clockwise

Revision 1.1  1997/04/02 08:59:58  chantem
Initial revision

Revision 1.1  1997/03/25 11:45:42  chantem
Initial revision

*/
