// AgentObserverSwarm.h

/*
static char Id="$Id: AgentObserverSwarm.h,v 1.5 1998/08/25 19:25:05 mgd Exp $"
*/

#import <simtoolsgui/GUISwarm.h>
#import <analysis.h>
#import <simtoolsgui.h>
#import "AgentModelSwarm.h"

@interface AgentObserverSwarm: GUISwarm
{
  int displayFrequency;	// one parameter: update freq

  int DemoChoice;  // to execute Swarm in demo mode
  int IntensiveMeasures;   // for multiple runs and output to a file
  int IterationThreshold;
  int ChoiceToStop;
  char FileNameExperiment[50];

  id displayActions; // schedule data structs
  id displaySchedule;

  AgentModelSwarm *agentModelSwarm; // the Swarm we are observing

  // Lots of display objects. First, widgets
  id <Colormap> colormap;	// allocate colours
  id <ZoomRaster> worldRaster; // 2d display widget
  id <Graph> StackGraph, BiggestStackGraph; // graphing widget
  id <GraphElement> StackData, BiggestStackData; // data element on graph

  // Now, higher order display and data objects
  id <Value2dDisplay> envDisplay; // display the heat
  id <Object2dDisplay> agentDisplay; // display the agents
  id <ActiveGraph> StackGrapher, BiggestStackGrapher; // object that does graph
  id <Histogram> useHisto;
}
-convert: (char *)buf: (char *)buf1;
-setIterationThreshold: (int)val;
-(int)getIterationThreshold;
-setDisplayFrequency: (int)val;
-(int)getDisplayFrequency;
-setDemoChoice: (int)val;
-setIntensiveMeasures: (int)val;
-(int)getDemoChoice;
-(int)getIntensiveMeasures;
-setChoiceToStop: (int)val;
-(int)getChoiceToStop;
-FileName: (char *)name;
-(char *)getFileName;
-updateHisto; 
-checkToStop;
-checkToStop1;
// Methods overriden to make the Swarm.
+createBegin: (id) aZone;
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

@end

/*
$Log: AgentObserverSwarm.h,v $
Revision 1.5  1998/08/25 19:25:05  mgd
* Makefile: Include from etc/swarm.
(SWARMHOME): Default to 1998-08-25.
(APPLIBS): Remove -lspace.

* AgentObserverSwarm.m ([AgentObserverSwarm -buildObjects]):
Use setX:Y: instead of setPositionX:Y:.

* AgentObserverSwarm.h: Include analysis.h.

Revision 1.4  1998/04/24 01:52:45  mgd
* WorldObject.m: Include collections.h.

* WorldObject.h: Include space/Discrete2d.h.  Add a WorldObject
protocol.

* Stack.h: Include objectbase/SwarmObject.h instead of objectbase.h.

* AgentProbaCamera.h: Include objectbase/SwarmObject.h instead of
objectbase.h.
(AgentProbaCamera): Make worldAgent conform to the Grid2d protocol.

* AgentProbaCamera.[hm]:
Make setWorlds:wAgt: first argument conform to Grid2d protocol,
and second conform to the WorldObject protocol.

* AgentObserverSwarm.h (AgentObserverSwarm): Make envDisplay
conform to the Value2dDisplay protocol.  Make agentDisplay
conform to the Object2dDisplay protocol.

* AgentModelSwarm.h: Include objectbase/Swarm.h instead of
objectbase.h.  Make worldAgent an object conforming to the
Grid2d protocol, likewise for getter.  Make worldObject an
object conforming to the WorldObject protocol, likewise for getter.

Revision 1.3  1998/02/28 08:47:18  mgd
* AgentProbaCamera.m: Include random.h instead of simtools.h.

* WorldObject.m: Likewise.

* AgentObserverSwarm.h: Don't include objectbase.h, space.h,
activity.h, gui.h, collections.h, or simtools.h.  Include
simtoolsgui/GUISwarm.h and simtoolsgui.h.

* AgentModelSwarm.m: Include random.h instead of simtools.h.

Revision 1.2  1998/02/04 01:08:05  mgd
* main.m (main): Constify argv.

* WorldObject.m ([WorldObject -RemoveObjects:::]): Initialize
oldsize and newsize to avoid warning.

* Stack.h: Include objectbase.h instead of swarmobject.h.

* Makefile (APPLIBS): Remove -lneuro and -lga.

* AgentProbaCamera.m ([AgentProbaCamera -determinesIntervalAngle:]):
Initialize intervalAng to avoid warning.
([AgentProbaCamera -determinesAngle:]):
Initialize angle to avoid warning.
([AgentProbaCamera -drawSelfOn:]): Make argument to drawSelfOn:
an id <Raster> instead of being statically typed.

* AgentProbaCamera.h:  Include objectbase.h and gui.h
instead of swarmobject.h and tkobjc/Raster.h.
([-drawSelfOn:r]): Make argument to drawSelfOn: an id <Raster>
instead of being statically typed.

* AgentObserverSwarm.m: Include objectbase.h instead of
swarmobject.h.  Constify StackColors and descr.  Include
simtools.h and gui.h.
(-convert::): Initialize j to avoid warning.
([AgentObserverSwarm +createBegin:]): Make probeMap comply with
the ProbeMap protocol rather than being statically typed.
([AgentObserverSwarm -buildObjects]): Use
CREATE_ARCHIVED_PROBE_DISPLAY for agentModelSwarm and
AgentObserverSwarm.  Send waitForControlEvent to actionCache
rather than controlPanel.  Create colormap from Colormap instead
of XColormap. Use setDisplayWidget:colormap: rather than
setDisplayWidget:Colormap:.  Create StackGraph from Graph instead
of BLTGraph. Use renamed setTitle: and setAxisLabelX:Y:.  Likewise
for BiggestStackGraph and useHisto.
([AgentObserverSwarm -updateHisto]): Use renamed
drawHistogramWithInt:.

* AgentObserverSwarm.h: Include gui.h instead of tkobjc.h.
Include objectbase.h instead of swarmobject.h.
(AgentObserverSwarm): Make colormap comply with the Colormap
protocol instead of being statically typed to XColormap.
Make worldRaster comply with the ZoomRaster protocol instead of
being statically typed.  Make StackGraph and BiggestStackGraph
comply with the Graph protocol instead of being statically
typed to BLTGraph.  Make StackData and BiggestStackData comply
with the GraphElement protocol instead of being statically typed.
Make StackGrapher and BiggestStackGrapher comply with the
ActiveGraph protocol instead of being statically typed.  Make
useHisto comply with the Histogram protocol instead of being
statically typed to Histo.

* AgentModelSwarm.m ([AgentModelSwarm -convert::]): Initialize
j to avoid warning.
([AgentModelSwarm +createBegin:]): Use id <ProbeMap> instead of
statically typing probeMap.

* AgentModelSwarm.h: Change swarmobject.h to objectbase.h.

Revision 1.1.1.1  1998/02/03 23:40:03  mgd
EnhApp import

Revision 1.1  1997/04/02 08:59:58  chantem
Initial revision

Revision 1.1  1997/03/25 11:45:42  chantem
Initial revision

*/
