//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JPanel;

/** 
 * Three color picker contains all the user interface colour
 * chooseing code. Sends there colors off to the
 * gradient diplay maker for sorting out into a gradient image.
 */
public class ThreeColorPicker extends JPanel {
	
	ArrayList colorList = new ArrayList();
	ColorPicker colorPicker;
	NumberInput numberInput;
	GradientDisp gDisp;

/**
 * sets up links and creates  internal panels: numberinput and colourpicker
 * @param gDisp_in
 * @param mainPanel_in
 * @param statusBar
 * @param gridPanel_in
 */
	public ThreeColorPicker(GradientDisp gDisp_in, MainPanel mainPanel_in, StatusBar statusBar, GridPanel gridPanel_in) {
		super(new BorderLayout());
		
		colorPicker = new ColorPicker(colorList, statusBar);
		numberInput = new NumberInput(colorPicker, colorList, statusBar);
		
		gDisp = gDisp_in;
		
		//pass color list to the gdisplay
		gDisp.setColorList(colorList);
		
		//pass gDisp to the colorpicker
		colorPicker.setGDisp(gDisp);
		
		//pass colorpicker to the gridpanel
		gridPanel_in.setColorPicker(colorPicker);
		
		//pass mainpanel to the colorPicker //will be a button soon
		colorPicker.setMainP(mainPanel_in);
		
		//set up sizes
		numberInput.setPreferredSize(new Dimension(250,200));
		colorPicker.setPreferredSize(new Dimension(250,200));
		
		//add to this panel
		add(numberInput,BorderLayout.WEST);
		add(colorPicker,BorderLayout.EAST);
		
		}
		
		public NumberInput setPreset(PresetColor presetColor){
			numberInput.setPreset(presetColor);
			return numberInput;
		}
		
		public void fileLoaded(){
			colorPicker.fileLoaded();
			
		}
		
		public void setSlider(SlidePanel slidePanel_in){
			colorPicker.setSlider(slidePanel_in);
		}
		
		public NumberInput getNumberInput(){
			return numberInput;
		}
		
		public ColorPicker getColorPicker(){
			return colorPicker;
		}
		
	}
