//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * @author 	S. Tokumine
 * @date	13-Aug-2003
 * @time	10:49:01
 * @file	StatusBar.java
 * 
 * @desc generic status bar for use at the bottom of the program
 * 		text is set via set text.
 *
 */
public class StatusBar extends JPanel{

	JLabel statusArea = new JLabel("Open an XML File to begin", JLabel.LEFT);
	
	/**
	 * Constructor sets up border of status area, color, font and font color etc.
	 */
	public StatusBar() {
		super();
		
		statusArea.setBorder(BorderFactory.createCompoundBorder(
		BorderFactory.createLineBorder(Color.GRAY,1),
		BorderFactory.createEmptyBorder(2,2,2,2)));
		
		statusArea.setForeground(Color.GRAY);
		statusArea.setBackground(Color.WHITE);
		statusArea.setOpaque(true);
		statusArea.setFont(new Font("SansSerif", Font.BOLD, 10));
		statusArea.setPreferredSize(new Dimension(1003,20));
		add(statusArea);	
	}
	
	public void setStatus(String status_in){
		statusArea.setText(status_in);
	}
}
