//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * @author 	S. Tokumine
 * @date	12-Aug-2003
 * @time	16:56:49
 * @file	ColorChooser.java
 * 
 * @desc A top level JPanel container for all the color picker 
 *       type controls and displays
 *
 */
public class ColorChooser extends JPanel {

	private GradientDisp gDisp; //gradient display
	private ThreeColorPicker TCP; //containter for user specified gradients
	private MainPanel mainPanel; //used to create keys
	private PresetColor presetColor; //preset colourscheme panel
	private GridPanel gridPanel; //preset grid panel

	/**
	 * Constructor sets up borders, lables and internal panels
	 *
	 */
	public ColorChooser(
		MainPanel mainPanel_in,
		ColorMapFactory colorMapFactory_in,
		StatusBar statusBar)
		throws HeadlessException {
		super();

		//set up reference 
		mainPanel = mainPanel_in;

		//create components for the colur picker panel
		gDisp = new GradientDisp(colorMapFactory_in);
		gridPanel = new GridPanel(colorMapFactory_in, statusBar);
		TCP = new ThreeColorPicker(gDisp, mainPanel, statusBar, gridPanel);
		presetColor = new PresetColor(gDisp, statusBar, TCP);

		//Add compound borders
		setBorder(
			BorderFactory.createCompoundBorder(
				BorderFactory.createTitledBorder(
					"Color Gradient Constructor and Choser: "),
				BorderFactory.createEmptyBorder(5, 5, 5, 5)));

		//create JPanel holding the labels for gradient display
		JPanel labels = new JPanel();
		JLabel lowLabel = new JLabel("Low");
		JLabel popLabel = new JLabel("<  Population Density  >");
		JLabel highLabel = new JLabel("High");

		lowLabel.setOpaque(true);
		popLabel.setOpaque(true);
		highLabel.setOpaque(true);

		lowLabel.setFont(new Font("SansSerif", Font.PLAIN, 15));
		popLabel.setFont(new Font("SansSerif", Font.PLAIN, 15));
		highLabel.setFont(new Font("SansSerif", Font.PLAIN, 15));

		lowLabel.setPreferredSize(new Dimension(140, 25));
		popLabel.setPreferredSize(new Dimension(250, 25));
		highLabel.setPreferredSize(new Dimension(50, 25));

		labels.add(lowLabel, BorderLayout.WEST);
		labels.add(popLabel, BorderLayout.CENTER);
		labels.add(highLabel, BorderLayout.EAST);

		//Size gradient and label panels 
		gDisp.setPreferredSize(new Dimension(512, 100)); //100 used to be 60
		labels.setPreferredSize(new Dimension(512, 27));

		//create parent Jpanel to hold the gradient display AND labels (high low density)
		JPanel display = new JPanel();

		//add gradient siaplay and labels to this parent panel
		display.add(gDisp, BorderLayout.PAGE_START);
		display.add(labels, BorderLayout.PAGE_END);
		display.setPreferredSize(new Dimension(512, 150));

		//add panel containtin gradient and labels to this JPanel (at the top)
		add(display, BorderLayout.PAGE_START);

		//set up the size of the user input controls and
		//add to this JPanel (in middle)
		TCP.setPreferredSize(new Dimension(517, 70));
		add(TCP, BorderLayout.CENTER);

		//set sizes of the preset and grid preset panels
		presetColor.setPreferredSize(new Dimension(326, 170));
		gridPanel.setPreferredSize(new Dimension(185, 170));

		//create parent Jpanel to hold the preset colour scheme and grid panels (high low density)
		//and add panels to it
		JPanel presetGrid = new JPanel();
		presetGrid.add(presetColor, BorderLayout.WEST);
		presetGrid.add(gridPanel, BorderLayout.EAST);
		presetGrid.setPreferredSize(new Dimension(521, 175));

		//add panel containing preserts to this JPanel (at the bottom)
		add(presetGrid, BorderLayout.SOUTH);

	}

	/**
	 * 
	 *allows us to signal when a file is loaded - sets up keys etc
	 */
	public void fileLoaded() {
		TCP.fileLoaded();
	}

	/**
	 * pass the slider as a reference - Dirty
	 * @param slidePanel_in 
	 */
	public void setSlider(SlidePanel slidePanel_in) {
		TCP.setSlider(slidePanel_in);
		//gridPanel.setSlider(slidePanel_in);
	}

	/**
	 * allows fitness key to be accessed
	 * @return image of fitness key
	 */
	public Image getFKey() {
		return gDisp.createFKey();
	}
}
