// By Benedikt Stefansson 1997
// Parts (C) by the Santa Fe Institute

// Simple object to output a t x agent dataset

#import <swarmobject.h>
#import <activity.h>
#import <collections.h>
#import <simtools.h>
#import <stdlib.h>
#import <stdio.h>
#import <malloc.h>
#import <math.h>

@class DataFile;
@class FullDataSet;
@class SimpleDataSet;
@class DataSequence;

@interface DataFile:Swarm {
  id dataSets,deathProbe;
}

-addFullDataSet: (char *) t withFeedFrom: d andSelector: (SEL) s;

-addSimpleDataSet: (char *) t withFeedFrom: d andSelector: (SEL) s;

-addSimpleDataSet: (char *) t withFeedFrom: d andSelectorA: (SEL) sA andSelectorB: (SEL) sB;

-addAverageSequence: (char *) t withFeedFrom: d andSelector: (SEL) s;

-addTotalSequence: (char *) t withFeedFrom: d andSelector: (SEL) s;

-setAlwaysActive;

-substituteCheckDeathWith: (SEL) s;

-step;

-(int)checkDeath: (id) anAgent;

-(void)drop;


@end

@interface FullDataSet:Swarm {
  FILE * theFile;
  char * title;
  SEL theSelector;
  id theCollection;
  id probe;
  id theManager;
  int round;

  int activeAgentCount;
  double periodAverage;
  double periodVariance;
  double periodSum;
  double periodSumSquared;
  double periodMin;
  double periodMax;

}

-setDataSet: (char *) t withFeedFrom: d andSelector: (SEL) s;

-setManager: (id) tO;

-createEnd;

-step;

-(void) drop;

// Support for statistics

-initializeStatistics;
	
-updateSummary: (double) data;

-newPeriod;

// Support for printing statistics

-printPeriodStatistics: (FILE *) aFile;

@end


@interface SimpleDataSet:Swarm {
  FILE * theFile;
  char * title;
  id theCollection;
  id probe,probeA,probeB;
  id theManager;
  SEL theSelector; 
  SEL theSelectorB;
  int complex,round;
}

-setDataSet: (char *) t withFeedFrom: d andSelector: (SEL) s;

-setDataSet: (char *) t withFeedFrom: d andSelectorA: (SEL) sA andSelectorB: (SEL) sB;

-setManager: (id) tO;

-createEnd;

-step;

-(void) drop;

@end


@interface DataSequence: Swarm {
  int average;
  int round;
  char * title;
  FILE * theFile;
  id theCollection;
  id theManager;
  id probe;
  SEL theSelector;
  
}

-setAverageSequence: (char *) t withFeedFrom: (id) d andSelector: (SEL) s;

-setTotalSequence: (char *) t withFeedFrom: (id) d andSelector: (SEL) s;


-setManager: (id) tM;

-createEnd;

-step;

-(void) drop;

@end







