#import "ObserverSwarm.h"
#import "ModelSwarm.h"
#import <collections.h>
#import <objectbase.h>
#import <analysis.h>
#import <gui.h>
#import <simtoolsgui/GUISwarm.h>
#import <simtoolsgui/ActionCache.h>

@implementation ObserverSwarm

// createBegin: here we set up the default observation parameters.
+createBegin: (id) aZone {
  ObserverSwarm * obj;
  id <ProbeMap> probeMap;
  
  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;
  obj->experimentDuration = 100;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [[probeLibrary getProbeForMessage: "ringDistribute"
			     inClass: [self class]]
			setHideResult: 1]];

  [probeMap addProbe: [[probeLibrary getProbeForMessage: "boingDistribute"
			     inClass: [self class]]
			setHideResult: 1]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

-createEnd {
  return [super createEnd];
}

-buildObjects {
  //  id modelZone;	tiyu

  [super buildObjects];

   modelSwarm = [ModelSwarm create: self];

  // Now create probe objects on the model and ourselves. This gives a
  // simple user interface to let the user change parameters.
  CREATE_ARCHIVED_PROBE_DISPLAY (modelSwarm);
  CREATE_ARCHIVED_PROBE_DISPLAY (self);

  //[controlPanel waitForControlEvent];
  //if ([controlPanel getState] == ControlStateQuit)
  //  return self;

  // Instruct the control panel to wait for a button event: we halt here
  // until someone hits a control panel button so the user can get a
  // chance to fill in parameters before the simulation runs  
  [controlPanel setStateStopped]; //tiyu
  //[modelSwarm buildObjects];
  // graphCanvas = [Canvas createBegin: [self getZone]];
  graphCanvas = [Canvas createBegin: self];
  SET_WINDOW_GEOMETRY_RECORD_NAME (graphCanvas);
  graphCanvas = [graphCanvas createEnd];

  [graphCanvas enableDestroyNotification: self
               notificationMethod: @selector (_graphCanvasDeath_:)];
 //STAGEDEPTH  "steps" back to front * ZOOMFACTORX pixels  displayed per step
  [graphCanvas setHeight: (STAGEDEPTH+1)* ZOOMFACTORX];
  //STAGEWIDTH "steps" deep * ZOOMFACTORY pixels per step
  [graphCanvas setWidth: (STAGEWIDTH+1)* ZOOMFACTORY] ;
  
  [graphCanvas setWindowTitle: "Dancer Graph"] ;
  [graphCanvas pack];	// draw the window.

  [graphCanvas packFillLeft: YES];
  GUI_UPDATE_IDLE_TASKS();

  //[globalTkInterp eval: 
  //    "pack %s -expand 1 -fill both ; update idletasks", 
  //    [graphCanvas getWidgetName]] ;
 
  [modelSwarm setGraphCanvas: graphCanvas] ;
  [modelSwarm buildObjects];

  return self ;
}  

-ringDistribute {
  [[modelSwarm getTheNet] redistribute] ;
  return self ;
}

-boingDistribute {
  [[modelSwarm getTheNet] boingDistribute] ;
  return self ;
}

-buildActions {
  [super buildActions];
  
  [modelSwarm buildActions];
  
  displayActions = [ActionGroup create: [self getZone]];

  //  [displayActions createActionTo: [modelSwarm getTheNet] message: M(boingStep)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: actionCache         message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  [displaySchedule at: 0 createActionTo: self message: M(checkToStop)];

  return self;
}  

- activateIn: (id) swarmContext {

  [super activateIn: swarmContext];

  [modelSwarm activateIn: self];

  [displaySchedule activateIn: self];

  return [self getSwarmActivity];
}

- checkToStop
{
  fprintf (stderr,"\n ObserverSwarm thinks the time is  %ld and experiment duration is %d: \n",getCurrentTime(), experimentDuration);
  if (getCurrentTime() > experimentDuration)
    {
      [controlPanel setStateStopped];
    }
  return self;

}


@end








