#import <stdlib.h>
#import <simtools.h>
#import "ModelSwarm.h"
#import "Dancer.h"

@implementation ModelSwarm

+createBegin: (id) aZone {
  ModelSwarm * obj;
  id <ProbeMap> probeMap;

  obj = [super createBegin: aZone];

  obj->population = 5 ;
  obj->eventRate = 40 ;
  obj->maxK = 3 ;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "population"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "eventRate"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "maxK"
				    inClass: [self class]]];

  [probeMap addProbe: [[probeLibrary getProbeForMessage: "hideDiGraph"
			     inClass: [self class]]
			setHideResult: 1]];

  [probeMap addProbe: [[probeLibrary getProbeForMessage: "showDiGraph"
			     inClass: [self class]]
			setHideResult: 1]];

 [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}


-createEnd {
  return [super createEnd];
}

- getTheNet {
  return theNet ;
}

- hideDiGraph 
{
  [theNet hideCanvas];
  return self;
}

- showDiGraph
{
  [theNet showCanvasUseNodeInfo: graphCanvas];
  //[theNet showCanvas: graphCanvas];
  return self;
}


-getEntityList {
  return entityList ;
}

-getRandomEntity {
  return [entityList atOffset: [uniformIntRand getIntegerWithMin: 0
                      withMax: ([entityList getCount] - 1)]];
}

-setGraphCanvas: aCanvas {
  graphCanvas = aCanvas ;
  return self ;
}

-buildObjects {
  int i;
  //intii,newK;
  //  id aNode;

  int * initialX =  [self allocBlock: population * sizeof(int)];

  int * initialY = [self allocBlock: population * sizeof(int)];

  initialX[0] = 4;
  initialX[1] = 5;
  initialX[2] = 6;
  initialX[3] = 7;
  initialX[4] = 2;

  initialY[0] = 5;
  initialY[1] = 4;
  initialY[2] = 3;
  initialY[3] = 2;
  initialY[4] = 2;

  [super buildObjects];
  printf("after create buildObjects.\n");
  theNet = [DiGraph createBegin: self] ;

  printf("after create DiGraph.\n");
  [theNet setCanvas: graphCanvas] ;
  [theNet createEnd] ;

  if  (!graphCanvas)printf("There is no graphCanvas");
  printf("In MS: Canvas : %d %d \n", [graphCanvas getWidth],[graphCanvas getHeight]);

  printf("after create theNet.\n");

  //initialize the time variable. 
  currentTime = 0;

  for(i = 0 ; i < population ; i++){
    
    id aDancer;
    char dancerName[10];

    sprintf(dancerName,"dncr%d",i+1);
    aDancer = [Dancer createBegin: self];
    [aDancer setNodeLabel: dancerName];

    aDancer = [aDancer createEnd];
    [aDancer setIDNumber: i+1];

    [aDancer setModelSwarm: self];



    //Here is how you set the starting position of the dancer.
    //it is done by adding the Node into the canvas at a certain position.
    //I wrote anew method in DiGraph for this. pj 2002-12-30
    [theNet addNode: aDancer atX: initialX[i]*ZOOMFACTORX Y: initialY[i]*ZOOMFACTORY];

    [aDancer findYourPosition];


    //can't talk to the node item until theNet has created it in addNode
    if (i==0) [aDancer  setColor: "LightBlue1"];
    if (i==1) [aDancer  setColor: "WhiteSmoke"];
    if (i==2) [aDancer  setColor: "LightSalmon1"];
    if (i==3) [aDancer  setColor: "LightPink1"];
    if (i==4) [aDancer  setColor: "LightGreen"];
  }

  printf("after addNode to theNet.\n");

  //This just grabs a link to the list of all items in the canvas
  entityList = [theNet getNodeList] ;


  //pj 2002-12-29
  //Disable Links because I don't know what use they serve in this particular model.
  //  for(i = 0 ; i < population ; i++){
  //   aNode = [entityList atOffset: i];
  //  newK = [uniformIntRand getIntegerWithMin: 0 withMax: maxK] ;
  //   for(ii = 0 ; ii < newK ; ii++){
  //       [theNet addLinkFrom: aNode To: [self getRandomEntity]] ;
  //   }
  // }
  

  //output file, text format

  sprintf (outputFileName, "Dancer.txt");

   outputFile = fopen (outputFileName,"w+");
  [self writeReportDataHeader];

  return self;
}

- (void)writeReportDataHeader
{
  fprintf (outputFile, "systemtime  dancer currentStep beginX beginY \n" );
  
}

- (void)writeReportData
{
  int i;  
    
  for(i = 0; i < [entityList getCount]; i++)
    {
      id aDancer = [entityList atOffset: i];
      
      fprintf (outputFile, "%5lu  %d %d %d %d\n",currentTime,[aDancer getIDNumber],[aDancer getStep],[aDancer getDancerX],[aDancer getDancerY]);
    }
}


- buildActions {
  [super buildActions];

//   modelActions = [ActionGroup create: [self getZone]];

//   [modelActions createActionTo: self message: M(step)] ;

//  modelSchedule = [Schedule createBegin: [self getZone]];

  outputSchedule = [Schedule create: self setRepeatInterval: 1];
  
  modelSchedule = [Schedule create: self setAutoDrop: YES];
  [modelSchedule at: 1 createActionTo: self message: M(step)]; //initiate dance

  [outputSchedule at: 0 createActionTo: self message: M(writeReportData)];

   
   //[modelSchedule setRepeatInterval: 1];
   // modelSchedule = [modelSchedule createEnd];
   //[modelSchedule at: 0 createAction: modelActions];
  
  
 
  return self;
}

- scheduleStepAt: (int)n For: aNode
{
  [modelSchedule at: n createActionTo: aNode message: M(updateTime)];
  [modelSchedule at: n createActionTo: aNode message: M(step)];
  return self;
}

- activateIn: (id) swarmContext {

  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];
  [outputSchedule activateIn: self];

  return [self getSwarmActivity];
}

- (void)step {

    id index = [entityList begin: self];
    id anObject;

    currentTime= getCurrentTime();

    for ( anObject=[index next]; [index getLoc]==Member; anObject=[index next])
      {
	[anObject updateTime];
        [anObject step]; //tells the dancer to do something
      }


 //   id newNode ;
//    int newK, i ;
//  //


//   if(![uniformIntRand getIntegerWithMin: 0
//                                 withMax: eventRate]){
//     if([uniformIntRand getIntegerWithMin: 0
//                                  withMax: 1]) {

//       newNode = [[[Dancer createBegin: [self getZone]]
//                          setNodeLabel: "Node"]
//                          createEnd] ;

//       newK = [uniformIntRand getIntegerWithMin: 0 withMax: maxK] ;
//       [theNet addNode: newNode] ;
//       for(i = 0 ; i < newK ; i++){
//         [theNet addLinkFrom: newNode To: [self getRandomEntity]] ;
//       }

//       printf ("step");
      
//     } else {
//       if([entityList getCount]) 
//         [theNet dropNode: [self getRandomEntity]] ;
//     }
//  }

  //return self ;
}

- (long int)getTime
{
   currentTime= getCurrentTime();
  return currentTime;

}


@end
