// Copyright (C) 1995-1998 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#import <objectbase/SwarmObject.h>
#import <gui.h>

@interface DiGraphNode: SwarmObject
{
  int x, y; //use as holding place for coordinates of node item
  char *color;
  char *label;
  id fromList;
  id toList;
  id <Canvas> canvas;
  id <NodeItem> nodeItem;
  id <Symbol> nodeType;
  id uRandPosition;
}

- setRandPosFunc: rp;
- setCanvas: aCanvas;
- setCanvas: aCanvas withRandPosFunc: posFunc;
- setCanvas: aCanvas atX: (int)xx Y: (int)yy;
- setNodeLabel: (const char *)aLabel;
- (void)setColor: (const char *) aColor;


- createEnd;
- getNodeItem;
- getToLinks;
- getFromLinks;
- makeLinkTo: aNode;
- makeLinkFrom: aNode;
- addFrom: aLink;
- addTo: aLink;
- removeFrom: aLink;
- removeTo: aLink;
- (int)linkedTo: anObj;
- (int)linkedFrom: anObj;
- (int)agreeX: (int)xx Y: (int)yy;
- updateLinks;
- hideNode;
- (void)drop;


@end
