// Copyright (C) 1995-1998 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#import <objectbase/SwarmObject.h>
#import <random.h>
#import <gui.h>

@interface DiGraph: SwarmObject
{
  id <List> nodeList;
  id <Canvas> canvas;

  int randPosSeed;
  id <PMMLCG1gen> randGPosition;
  id <UniformIntegerDist> uRandPosition;
  // For BoingDistribute...
  float springLength;
}

- setRandPosSeed: (int)seed;
- setCanvas: aCanvas;
- setCanvas: aCanvas withRandPosSeed: (int)seed;
- showCanvas: aCanvas;
- showCanvasUseNodeInfo: aCanvas;
- hideCanvas;
- getCanvas;
- getNodeList;
- addNode: aNode;
- addNode: aNode atX: (int) x Y: (int) y;
- dropNode: which;
- addLinkFrom: this To: that;
- removeLink: aLink;
- update;

// Node placement techniques...

- redistribute;

- setSpringLength: (float) aLength;
- boingDistribute: (int) iterations;
- boingDistribute;
- (double) boingStep;

@end
