#import "Dancer.h"
#import "graph.h"
#import <random.h>
#import "ModelSwarm.h"

@implementation Dancer

- setIDNumber: (int) n
{
  idNumber = n;
  return self;
}

- (int)getIDNumber
{
  return idNumber;
}


- setModelSwarm: model
{
  modelSwarm =  model;
  return self;
}

+ createBegin: (id) aZone {

  Dancer * obj;
  id <ProbeMap> probeMap;

  obj = [super createBegin: aZone];
  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "idNumber"
				    inClass: [self class]]];


  [probeMap addProbe: [probeLibrary getProbeForVariable: "plannedX"
				    inClass: [self class]]];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "plannedY"
				    inClass: [self class]]];

  [probeMap addProbe: [probeLibrary getProbeForMessage: "planStep:Dir:Rep:"
			     inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

 return obj;


}



- createEnd
{
  duration[0]=1;
  duration[1]=3;
  duration[2]=12;
  duration[3]=3;
  duration[4]=6;
  duration[5]=6;
  duration[6]=3;
  duration[7]=3;
  duration[8]=1;
  duration[9]=3;
 
  currentStep = 0; //They stand still at time 0

  return [super createEnd];

}



- (void)findYourPosition
{
  pastX = [nodeItem getX]/ZOOMFACTORX;
  pastY = [nodeItem getY]/ZOOMFACTORY;
}


- (BOOL)planStep: (int) stepNumber Dir: (int)direction Rep: (int) rep
{
  int diffx=0,diffy=0; //these are the position changes for each step.
  char stepName[10];
  switch (stepNumber)
    {
      //Stand (1 direction)
    case 0:
      {
	
	diffx=0;
	diffy=0;
	sprintf(stepName,"%d: Stand",idNumber);

	[self changeLabel: stepName];
	
	break;
      }
    //Run (8 directions)
    case 1: 
      {
	sprintf(stepName,"%d: Run",idNumber);

	[self alter8DirectionsX: &diffx Y: &diffy Dir: direction  Rep: rep];
	[self changeLabel: stepName];
     
	
	break;
      }

      //2. Roll Forward: Ignore directional input 
    case 2:
      {
	 {
	    diffx=0;
	    diffy=1;
	  }
	 sprintf(stepName,"%d: R.F.",idNumber);
	[self changeLabel: stepName];
      
	break;
      }


      //3. Pas de Bourree
    case 3:
      {

	diffx=0;
        diffy=0;
	
	sprintf(stepName,"%d: PdB",idNumber);
	[self changeLabel: stepName];
	
	break;
      }

      //4.Soutenu Turn, 2 directions. L or R
    case 4:
      {
       	if (direction==0)
	  {
	    diffx = 1;
	    diffy = 0;
	  }
	else 
	  {
	    diffx = -1;
	    diffy = 0;
	  }
	sprintf(stepName,"%d: S.T.",idNumber);
	[self changeLabel: stepName];
	break;
      }


    //5.Balance
    case 5:
      {

	[self alter8DirectionsX: &diffx Y: &diffy Dir: direction  Rep: rep];
 	sprintf(stepName,"%d: Bal",idNumber);
	[self changeLabel: stepName];	
	break;
      }
      
      //6. Grand Jete: 1 unit, 8directions
    case 6:
      {
     	diffx = 0;
	diffy = 0;
	sprintf(stepName,"%d: G.J.",idNumber);
	[self changeLabel: stepName];

	break;
      }
      
      //7. Par de chat (2 directions)
    case 7:
      {
       if (direction == 0)
	  {
	    diffx = -1;
	    diffy = 0; 
	  }
	else 
	  {
	    diffx = 1;
	    diffy = 0; 
	  }
       sprintf(stepName,"%d: P.d.C.",idNumber);
       [self changeLabel: stepName];
       break;
      }
      
      //8. Swing leg side (2 directions)
    case 8:
      {
	if (direction == 0)
	  {
	    diffx = -1;
	    diffy = 0; 
	  }
	else 
	  {
	    diffx = 1;
	    diffy = 0; 
	  }
	sprintf(stepName,"%d: S.L.S.",idNumber);
	[self changeLabel: stepName];	
        
	break;
      }
      
      // 9. Roll side way (2 directions)
    case 9:
      {
	if (direction == 0)
	  {
	    diffx = -1;
	    diffy = 0; 
	  }
	else 
	  {
	     diffx = +1;
	    diffy = 0; 
	  }
	sprintf(stepName,"%d: R.S.",idNumber);
	[self changeLabel: stepName];	
	break;
      }
  
      //default case: stand is step 0;
    default:
	sprintf(stepName,"%d: Stand.",idNumber);
	[self changeLabel: stepName];
	diffx = 0;
	diffy = 0;
	break;
    } //ends the switch


  // now carry out the move.
  // multiply diff by "rep" because you move for so many repetitions
  // I'm just "projecting" these by multiplying.  ANything more complicated
  // could be done, but would have to be inside the switches above and use
  // knowledge of a dancer.
  //the planMove method checks boundaries and also for collisions with other dancers.

  return [self planMoveX: (diffx*rep) Y: (diffy*rep)];
 
}//closes step: Dir: method

- (void)updateTime
{
  timeNow = [modelSwarm getTime];
}

- (unsigned long) getInternalTime
{
  return timeNow;
}


- (void)step 
{
  fprintf (stderr,"\n Dancer Number: %d Time: %ld \n" , idNumber, timeNow);
  //  fprintf (stderr,"I think the current Canvas size is: width: %d pixels height: %d pixels \n",[canvas getWidth],[canvas getHeight]);
  // fprintf (stderr,"My pixel position in the canvas  is: %d pixels x %d pixels \n",[nodeItem getX],[nodeItem getY]);
  // fprintf (stderr,"Viewing the dance floor as an %d by %d area, I'm starting this move in square (%d,%d)\n",
  //	   (int)[canvas getWidth]/ZOOMFACTORX,(int)[canvas getHeight]/ZOOMFACTORY,[nodeItem getX]/ZOOMFACTORX,[nodeItem getY]/ZOOMFACTORY);
  
  //Just an example of movements. On even numbered steps, take one
  //more unit of x and y.  This can be made "arbitrarily complicated".
  //For example, for a dance with 100 steps, one could write-out an
  //array of 100 movements. We could then save that array, and re-run
  //the dance.  I can work it out pretty easily if needed. pj 2002-12-31

  if (movedAlready != YES)
    {
      int nextStep = [self chooseNextStep: currentStep];
      int nextDirection = [self chooseNextDirection: nextStep];
      int nextReps = [self chooseNextReps: nextStep];
      BOOL didMove = NO;
      //Tell self to step with arguments (stepType, Direction, and Number of Repetitions).
      
      didMove = [self planStep: nextStep Dir: nextDirection Rep: nextReps];
      
      if (didMove == YES)
	{
	  currentStep = nextStep;

	  [modelSwarm scheduleStepAt: timeNow+(duration[nextStep]*nextReps) For: self];

	  fprintf(stderr,"Dancer: %d InternalTime: %lu SystemTime %lu I have currentStep is %d, my nextStep is %d, my nextDirection is %d, my reps is %d\n",idNumber,timeNow,[modelSwarm getTime], currentStep, nextStep, nextDirection, nextReps);
	}
      else
	{
	  fprintf(stderr,"Failed to move. trying over");
	  [self step];
	}
    }
  movedAlready = NO;
}


- (int) chooseNextStep: (int) aStep
{
  int nextStep = 0;
  if ( aStep == 0 || aStep == 1 || aStep == 6 )
    {
      nextStep = [self randInt: 7];  //any step between 0 and 7
    }
  else if ( aStep == 2)
    {
      int rnd = [self randInt: 2] == 0;
      if ( rnd == 0 ) nextStep = 0;
      else if ( rnd == 1 ) nextStep = 8;
      else nextStep = 9;
    }
  else if ( aStep == 8|| aStep == 9 )
    {
      nextStep = [self randInt: 9];//any step 0 through 9
    }

  else if ( aStep == 4 || aStep == 5 || aStep == 7)
    {
      int rnd = [self randInt : 6];
      if (rnd == 6) rnd = 7;
      nextStep = rnd;
    }
  return nextStep;
}

- (int) chooseNextDirection: (int) aStep
{
  int chosenDirection = 0;

  if ( aStep == 0 || aStep == 2) chosenDirection = 0; //no direction relevant
 
  //2 directions only
  if ( aStep == 4 || aStep == 7 || aStep ==  8 || aStep == 9 )  
    {
      chosenDirection = [self randInt: 1];
    }
  if ( aStep == 1 || aStep == 3 || aStep == 5 || aStep == 6 )
    {
      chosenDirection = [self randInt:  7];
    }
  return chosenDirection;
}

- (int)chooseNextReps: (int) aStep
{
  return 1; //only once
}


//Lucky for us, all 8 directional steps only have a distance of 1. So we don't
//need to pass a distance or step related detail.
- (void)alter8DirectionsX: (int *) xx Y: (int *) yy Dir: (int) zz Rep: (int) hh
{
  if (zz == 0){ *xx = 0;   *yy =1*hh; }
  if (zz == 1){ *xx = 1*hh; *yy = 1*hh ;}
  if (zz == 2){ *xx = 1*hh; *yy = 0; }
  if (zz == 3){ *xx = 1*hh; *yy = -1*hh ;}
  if (zz == 4){ *xx = 0; *yy = -1*hh; }
  if (zz == 5){ *xx = -1*hh; *yy = -1*hh; }
  if (zz == 6){ *xx = -1*hh; *yy = 0; }
  if (zz == 7){ *xx = -1*hh; *yy = 1*hh; }
  
}


- (int)randInt: (int) n
{
  return [uniformIntRand getIntegerWithMin: 0 withMax: n];
}


- changeLabel: (char*) str
{
  [nodeItem resetString: str];
  label = strdup(str);
  return self;
}


- (BOOL)planMoveX:(int) xx Y: (int)yy
{

  int diffx = xx;
  int diffy = yy;
  int currentx = [nodeItem getX]/ZOOMFACTORX; //position as dancer sees it in "strides"
  int currenty = [nodeItem getY]/ZOOMFACTORY;
  id anObject;

  //check to see if we are stepping out of bounds, if so, reduce to invisible outer edge of stage.
  if (currentx + diffx < 0) diffx = 0 - currentx;  //put at position 0.
  else if ((currentx + diffx) > STAGEWIDTH) diffx = STAGEWIDTH - currentx + 1 ;

  if (currenty + diffy < 0) diffy =  1 - currenty ;  //put at position 1:as far up as possible.
  else if ((currenty + diffy) > STAGEDEPTH) diffy = STAGEDEPTH - currenty; //square 8, as far down as possible

  if ((anObject = [self checkOpenSpaceX: (currentx + diffx) Y: (currenty + diffy)]))
    {
      fprintf (stderr,"\n \noops, there is already somebody planning to go to %d,%d, it is %d \n\n",(currentx+diffx),(currenty+diffy),[anObject getIDNumber]);
      //oops, somebody is already there
      //so restart your step method to try another location.
      return NO;
    }

  else 
    {
      pastX = currentx;
      pastY = currenty;
      plannedX = currentx + diffx;
      plannedY = currenty + diffy;
      [nodeItem moveX: diffx*ZOOMFACTORX Y: diffy*ZOOMFACTORY];    
 
      fprintf(stderr, "There's nobody there\n");

      fprintf (stderr,"Viewing the dance floor as an %d by %d area, I'm finishing this move in square (%d,%d)\n",
	   (int)[canvas getWidth]/ZOOMFACTORX,(int)[canvas getHeight]/ZOOMFACTORY,[nodeItem getX]/ZOOMFACTORX,[nodeItem getY]/ZOOMFACTORY);
      movedAlready = YES;

   }
  return YES;
}


- checkOpenSpaceX: (int) xx Y: (int) yy
{
  id someoneThere = nil;
  id index = [[modelSwarm getEntityList] begin: [self getZone]];
  id anObject;

  for (anObject = [index next]; [index getLoc]==Member; anObject=[index next])
    {
      if (anObject != self)
	{
	  if ( [anObject getPlannedX] == xx )
	    {
	      if ( [anObject getPlannedY] == yy )
		{
		  someoneThere = anObject;
		  return someoneThere; //as soon as you find a conflict, return a NO.
		}
	    }
	}
    }
  return nil;
}

- (int)getDancerX
{
  //return [nodeItem getX]/ZOOMFACTORX;
    return pastX;
    //return plannedX;
}


- (int)getDancerY
{
  //return plannedY;
  return pastY;
  //return [nodeItem getY]/ZOOMFACTORY;
}

- (int)getPlannedX
{
  return plannedX;
}

- (int)getPlannedY
{
  return plannedY;
}

- (int)getStep
{
  return currentStep;
}

@end
