#import <simtoolsgui.h>
#import "ObserverSwarm.h"

@implementation ObserverSwarm: GUISwarm

+ createBegin: aZone
{
  ObserverSwarm * obj;
  obj = [super createBegin: aZone];
  obj->takePictures = NO;
  return obj;
}

- createEnd
{
  return [super createEnd];
}



//////////////////////////////////////////////////
//
// buildObjects
//
//////////////////////////////////////////////////
- buildObjects
{

  unsigned int rasterX;
  unsigned int rasterY;


  //  printf ("ObserverSwarm\tbuildObjects\n");
  [super buildObjects];
  

  modelSwarm = [ModelSwarm create: self];

  //
  // The model must be "loaded" before the boidRaster is created
  //
  [ObjectLoader load: modelSwarm fromFileNamed: "BoidWorld.Params"];

  
  CREATE_PROBE_DISPLAY (modelSwarm);

  [controlPanel setStateStopped];

  colorMap = [Colormap create: self];

  [colorMap setColor: 0 ToName: "white"];
  [colorMap setColor: 1 ToName: "green"];
  [colorMap setColor: 2 ToName: "blue"];
  [colorMap setColor: 3 ToName: "black"];
  [colorMap setColor: 4 ToName: "red"];
  [colorMap setColor: 5 ToName: "purple"];


  boidRaster = [ZoomRaster createBegin:  self];
  boidRaster = [boidRaster createEnd];
  [boidRaster enableDestroyNotification: self
               notificationMethod: @selector (_boidRasterDeath_:)];

  //[boidRaster setColormap: boidColormap];
  [boidRaster setColormap: colorMap];

  SET_WINDOW_GEOMETRY_RECORD_NAME (boidRaster);

  rasterX = [modelSwarm  getWorldXSize];
  rasterY = [modelSwarm  getWorldYSize];
  //rasterSize = (rasterX >= rasterY ? rasterX : rasterY )/rasterResolution;
  //[adultRaster setZoomFactor: rasterZoomFactor];
  [boidRaster setZoomFactor: 1];

  [boidRaster setWidth: rasterX Height: rasterY];

  [boidRaster setWindowTitle: "Boid World"];
  [boidRaster pack];				

  [modelSwarm setRaster: boidRaster];
  [modelSwarm buildObjects];

  boidDisplay = [Object2dDisplay createBegin: self];
  [boidDisplay setDisplayWidget: boidRaster];
  [boidDisplay setDiscrete2dToDisplay: [modelSwarm getBoidSpace]];
  [boidDisplay setObjectCollection: [modelSwarm getBoids]];
  [boidDisplay setDisplayMessage: M(drawSelfOn:)];   // draw method
  boidDisplay = [boidDisplay createEnd];

  //
  // create some probes
  //
  [self buildProbeMaps];


/*
  canvas = [Canvas create: globalZone];
  [canvas setWidth: [modelSwarm getWorldXSize] 
	  Height: [modelSwarm getWorldYSize]];
  [canvas setWindowTitle: "Flock World"];
  [canvas pack];

  [modelSwarm setCanvas: canvas];

*/


/*
  popGraph = [EZGraph createBegin: [self getZone]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (popGraph);
  [popGraph setTitle: "Poplulation vs. time"];
  [popGraph setAxisLabelsX: "time" Y: "population"];
  popGraph = [popGraph createEnd];

  [popGraph createSequence: "Population"
            withFeedFrom: [modelSwarm getObjectList] 
            andSelector: M(getCount)];
*/
  return self;
}  




///////////////////////////////////////////////////////////
// 
// buildActions
//
//////////////////////////////////////////////////////////
- buildActions
{
  //  printf ("ObserverSwarm\tbuildActions\n");
  [super buildActions];
  
  // build the actions for the model's schedule
  [modelSwarm buildActions];

  // create the display actions
  displayActions = [ActionGroup create: [self getZone]];
  [displayActions createActionTo: actionCache message: M(doTkEvents)];
  //[displayActions createActionTo: popGraph    message: M(step)];
  //[displayActions createActionTo: modelSwarm  message: M(display)];
  [displayActions createActionTo: self message: M(updateRaster)];

  // then actually schedule the display actions
  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: 1];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];
  [displaySchedule at: 0 createActionTo: self message: M(writeFrame)];

  return self;
}  

//////////////////////////////////////////////////////
//
// updateRaster
//
/////////////////////////////////////////////////////
- updateRaster {

   if (boidRaster) {
       [boidRaster erase];
       [boidDisplay display];
       [boidRaster drawSelf];
    }

   return self;

}


//////////////////////////////////////////////////////////
//
// activateIn
//
////////////////////////////////////////////////////////
- activateIn: swarmContext
{
  [super activateIn: swarmContext];
  [modelSwarm activateIn: self];
  [displaySchedule activateIn: self];
  
  return [self getSwarmActivity];
}



/////////////////////////////////////////////////////
//
// getDisplay
//
//////////////////////////////////////////////////////
- getDisplay
{
  return canvas;
}




///////////////////////////////////////////////////
//
////    PROBES
//////
///////
////////
///////////////////////////////////////////////////

- buildProbeMaps {

  id <ProbeMap> probeMap;

  probeMap = [CustomProbeMap create: [self getZone] forClass: [BoidSpace class]
                             withIdentifiers: "newLocationX",
                                                ":",
                                               "send:fishToX:Y:",
                                               NULL];
   [probeLibrary setProbeMap: probeMap For: [BoidSpace class]];


  CREATE_PROBE_DISPLAY ([modelSwarm getBoidSpace]);

  probeMap = [CustomProbeMap create: [self getZone] forClass: [ParameterSpace class]
                             withIdentifiers: "interactionDist",
                                              "maxVelocity",
                                              "maxAcceleration",
                                              "fieldOfView",
                                              "centeringStrength",
                                              "velocityMatchStrength",
                                              ":",
                                               NULL];
   [probeLibrary setProbeMap: probeMap For: [ParameterSpace class]];


  CREATE_PROBE_DISPLAY ([modelSwarm getParameterSpace]);

  probeMap = [CustomProbeMap create: [self getZone] forClass: [ObserverSwarm class]
                             withIdentifiers: "takePictures",
                                                ":",
                                               "startTakingPictures",
                                               NULL];
   [probeLibrary setProbeMap: probeMap For: [ObserverSwarm class]];


  CREATE_PROBE_DISPLAY (self);

  return self;

}

- (void) startTakingPictures {

  takePictures = YES;
}

-(void) writeFrame {

  if(takePictures) {
  char filename[256];
  id pixID;

 sprintf(filename, "Frame%03ld.png", getCurrentTime());

 pixID =  [Pixmap createBegin: [self getZone]];
 [pixID  setWidget: boidRaster];
 pixID = [pixID createEnd];
 [pixID save: filename];
 [pixID drop];
 
 } //takePictures
}


@end

