#import <objectbase/SwarmObject.h>

@protocol Vector
- (void) drop;
- (id <Vector>)init;
- (id <Vector>)init: (id <Vector>)v;
- (id <Vector>)init: (double) x0: (double) y0;
- (id <Vector>)normalize;
- (id <Vector>)add: (id <Vector>)v;
- (id <Vector>)sub: (id <Vector>)v;
- (id <Vector>)div: (double) d;
- (id <Vector>)mult: (double) d;
- (id <Vector>)cross: (id <Vector>)v;
- (id <Vector>)neg;
- (id <Vector>)right;
- (id <Vector>)left;
- (double) dot: (id <Vector>)v;
- (double) angle: (id <Vector>)v;
- (double) getLength;
- (double) getX;
- (double) getY;
- (id <Vector>)setX: (double) xx;
- (id <Vector>)setY: (double) yy;
- (int) eq: (id <Vector>)v; // equality
- (id <Vector>)setDirection: (id <Vector>)v;
- (id <Vector>)setLength: (double) l;
- (id <Vector>)print;
@end

@interface Vector: SwarmObject <Vector>
{
  @public
  double x, y;
}

+ (Vector *)create: aZone;
- (id <Vector>)init;
- (id <Vector>)init: (id <Vector>)v;
- (id <Vector>)init: (double) x0: (double) y0;

- (id <Vector>)normalize;

- (id <Vector>)setDirection: (id <Vector>)v;
- (id <Vector>)setLength: (double) l;
//- setLength: (id <Vector>)v;

- (double) dot: (id <Vector>)v;
- (id <Vector>)add: (id <Vector>)v;
- (id <Vector>)sub: (id <Vector>)v;
- (id <Vector>)div: (double) d;
- (id <Vector>)mult: (double) d;
- (id <Vector>)cross: (id <Vector>)v;
- (id <Vector>)neg;
- (id <Vector>)right;
- (id <Vector>)left;
- (double) angle: (id <Vector>)v;
- (double) getLength;
- (double) getX;
- (double) getY;
- (double) setX;
- (double) setY;
- (id <Vector>)setX: (double) xx;
- (id <Vector>)setY: (double) yy;
- (int) eq: (id <Vector>)v; // equality

- (id <Vector>)print;
@end
