// PriorityQueue.m

#import "PriorityQueue.h"

@implementation PriorityQueue

+ (PriorityQueue *)create: aZone
{
  PriorityQueue *obj = [super create: aZone];
  obj->parent  = nil;
  obj->size    = 0;
  obj->subject = nil;
  obj->higher  = nil;
  obj->lower   = nil;
  return obj;
}

+ (PriorityQueue *)create: aZone withParent: (PriorityQueue *) aQueue
{
  PriorityQueue *obj = [super create: aZone];
  obj->parent  = aQueue;
  obj->size    = 0;
  obj->subject = nil;
  obj->higher  = nil;
  obj->lower   = nil;
  return obj;
}



- (void) drop {

   if(0) {
     fprintf(stderr,"PRIORITYQUEUE >>>> drop\n");
     fflush(0);
   }


   parent = nil;
   size = 0;
   subject = nil;
   higher = nil;
   lower = nil;

   [super drop];

}




- (int) getCount
{
  return size;
}

- rollBackAdd
{
  size--;
  if (parent != nil)
    return [parent rollBackAdd];
  else
    return self;
}

- balanceLower
{
  // To keep the binary tree balanced, we can juggle
  // values and pointers.

  // We also need to be able to remove the top of the
  // tree. But we can't do that while it is the top,
  // so it has to be moved.

  // Here we balance towards the 'lower' end.

  id     aSubject  = subject;
  double  aPriority = priority;
  PriorityQueue *aHigher   = higher;
  PriorityQueue *aLower    = lower;

  if (higher != nil) {
    subject  = aHigher->subject;
    priority = aHigher->priority;
    lower    = aHigher;
    higher   = aHigher->higher;
    if (higher != nil) higher->parent = self;

    aHigher->subject  = aSubject;
    aHigher->priority = aPriority;
    aHigher->higher   = aHigher->lower;
    aHigher->lower    = aLower;
    if (aLower != nil) aLower->parent = aHigher;
    // aHigher->parent == self
    // aHigher->higher->parent == aHigher
    lower->size =
      (int) [lower->lower  getCount] +
      (int) [lower->higher getCount] + 1;
    size =
      (int) [lower  getCount] +
      (int) [higher getCount] + 1;
  }
  return self;
}

- balanceHigher
{
  // To keep the binary tree balanced, we can juggle
  // values and pointers

  // Here we move it towards the 'higher' end.

  id     aSubject  = subject;
  double  aPriority = priority;
  PriorityQueue *aHigher   = higher;
  PriorityQueue *aLower    = lower;

  if (lower != nil) {
    subject  = aLower->subject;
    priority = aLower->priority;
    higher   = aLower;
    lower    = aLower->lower;
    if (lower != nil) lower->parent = self;

    aLower->subject  = aSubject;
    aLower->priority = aPriority;
    aLower->lower    = aLower->higher;
    aLower->higher   = aHigher;
    if (aHigher != nil) aHigher->parent = aLower;
    // aLower->parent == self
    // aLower->lower->parent == aLower
    higher->size =
      (int) [higher->lower  getCount] +
      (int) [higher->higher getCount] + 1;
    size =
      (int) [lower  getCount] +
      (int) [higher getCount] + 1;
  }
  return self;
}

- addObject: anObject with: (double) aPriority
{
  size++;
  if (subject == nil) {
    subject = anObject;
    priority = aPriority;
    return self;
  }
  // I want to avoid duplicate objects.
  // This works on the odd-chance we happen to
  // pass by the same object while adding it again.
  // If the priority is unchanged, this is bound to happen.
  // If the priority changes, then duplicates can not
  // be avoided without a more complex data structure.
  if (subject == anObject)
    return [self rollBackAdd];

  // this is the right place to balance a tree, so, here goes
  // this is just pointer manipulation, so it is a constant cost,
  // so it dosen't affect the time complexity of the addObject.
  
  if (higher != nil) {
    if (lower != nil) {
      if ([higher getCount] * 2 + 1 < [lower getCount])
	[self balanceHigher];
      else
	if ([lower getCount] * 2 + 1 < [higher getCount])
	  [self balanceLower];
    } else { // lower == nil
      if ([higher getCount] > 3)
	[self balanceLower];
    }
  } else { // higher == nil
    if (lower != nil) {
      if ([lower getCount] > 3)
	[self balanceHigher];
    }
  }
  
  if (aPriority > priority) {
    if (higher == nil)
      higher = [PriorityQueue create: [self getZone] withParent: self];
    return [higher addObject: anObject with: aPriority];
  } else {
    if (lower == nil)
      lower = [PriorityQueue create: [self getZone] withParent: self];
    return [lower addObject: anObject with: aPriority];
  }
}

- addQueue: (PriorityQueue *) aQueue
{
  if (subject == nil) {
    size = aQueue->size;
    subject = aQueue->subject;
    priority = aQueue->priority;
    higher = aQueue->higher;
    lower = aQueue->lower;
    [aQueue drop];
  } else {
    size += [aQueue getCount];
    if (aQueue->priority > priority) {
      if (higher == nil) {
	higher = aQueue;
	aQueue->parent = self;
      } else
	[higher addQueue: aQueue];
    }
    else {
      if (lower == nil) {
	lower = aQueue;
	aQueue->parent = self;
      } else
	[lower addQueue: aQueue];
    }
  }
  return self;
}

- getFirst
{
  if (higher != nil)
    return [higher getFirst];
  else
    return subject;
}

- getLast
{
  if (lower != nil)
    return [lower getLast];
  else
    return subject;
}

- removeFirst
{
  if (subject == nil) // error: remove on empty PriorityQueue
    return nil;
  size--;
  if (higher != nil) { // there are 'better' subjects
    if ([higher getCount] > 1) {
      // higher has children
      return [higher removeFirst];
    } else { // higher has no childen, so it is dropped
      id obj = higher->subject;
      [higher drop];
      higher = nil;
      return obj;
    }
  } else if (lower != nil) {
    PriorityQueue *aQueue;
    // no 'better' subjects, so I must be returned
    if (parent == nil) {
      // top of the tree, gotta be carefull not to invalidate pointer!
      [self balanceHigher];
      aQueue = self;
    } else {
      // we have to link up the lower branch
      parent->higher = lower;
      lower->parent = parent;
      aQueue = lower; // remember my lower
      lower = nil;    // I am now a leaf
      size = 1;       // with one element: subject
      [aQueue addQueue: self]; // add myself to my prev. lower
    }
    // remove the 'First', which will be me:
    return [aQueue removeFirst];
  } else { // this PriorityQueue begins with me
    id obj = subject;
    subject = nil;
    size = 0;
    return obj;
  }
  return nil; // error.
}

- removeLast
{
  if (subject == nil) // error: remove on empty PriorityQueue
    return nil;
  size--;
  if (lower != nil) { // there are lower subjects
    if ([lower getCount] > 1) { // lower has children
      return [lower removeLast];
    }
    else { // lower has no childen, so it is dropped
      id obj = lower->subject;
      [lower drop];
      lower = nil;
      return obj;
    }
  } else if (higher != nil) {
    PriorityQueue *aQueue;
    // no lower subjects, so I must be returned
    if (parent == nil) {
      // top of the tree, gotta be carefull not to invalidate pointer!
      [self balanceLower];
      aQueue = self;
    } else {
      // and we have to link up the higher branch
      parent->lower = higher;
      higher->parent = parent;
      aQueue = higher; // remember my higher
      higher = nil;    // I am now a leaf
      size = 1;        // with one element: subject
      [aQueue addQueue: self]; // add myself to my prev. higher
    }
    // remove the 'Last', which will be me:
    return [aQueue removeLast];
  } else { // this PriorityQueue begins with me
    id obj = subject;
    subject = nil;
    size = 0;
    return obj;
  }
  return nil; // error.
}






///////////////////////////////////////
//
// removeAll;
//
//////////////////////////////////////
- removeAll {
  PriorityQueue* obj;

  obj = self;

  if(obj->higher != nil) {

      [obj->higher removeAll];

  }
  if(obj->lower != nil) {

      [obj->lower removeAll];

  }

  size = 0;
  subject = nil;
 
  if (higher) [higher drop]; higher = nil;
  if (lower)  [lower  drop]; lower  = nil;

  return self;
}




//////////////////////////////////////////////////
//
// forEach
//
/////////////////////////////////////////////////

- (void) forEach: (SEL) op
{
  [subject perform: op];
  [higher forEach: (SEL) op];
  [lower  forEach: (SEL) op];
}

- (void) forEach: (SEL) op : arg
{
  [subject perform: op with: arg];
  [higher forEach: (SEL) op : arg];
  [lower  forEach: (SEL) op : arg];
}
@end
