
#import <simtools.h>
#import <gui.h>
#import <space/Discrete2d.h>
#import <objectbase.h>
#import <simtoolsgui/GUISwarm.h>
#import <analysis.h> // EZGraph

#import "ModelSwarm.h"

@interface ObserverSwarm: GUISwarm 
{
  id <NodeItem> critter1, critter2;

  id displayActions;   // ActionGroup *
  id displaySchedule;  // Scedule *

  ModelSwarm* modelSwarm;

  id <Colormap> colorMap;                        // allocate colours
  id <Canvas> canvas;                            // 2d display widget
 
  id <ZoomRaster> boidRaster;
  id <Object2dDisplay> boidDisplay;

  BOOL takePictures;

  //id <EZGraph> popGraph;
  //  id <EZGraph> emotionGraph;
  //  id <Histogram> emotionHisto;
}

+ createBegin: aZone;
- createEnd;
- buildProbeMaps;
- buildObjects;
- buildActions;
- activateIn: swarmContext;
- getDisplay;


- (void) startTakingPictures;
- (void) writeFrame;

@end

