#import "Boid.h"
#import <math.h>

@implementation Boid

+ (Boid *)create: aZone {
  Boid* obj=[super create: aZone];

  obj->acceleration = [Vector create: aZone]; // initially {0,0}
  obj->flockCenter  = [Vector create: aZone];
  obj->yourCalcPosition  = [Vector create: aZone];
  obj->flockVelocity  = [Vector create: aZone];

  obj->closestBoid = self;
  //obj->closestPred = nil;
  //obj->closestObstacle = nil;
  
  obj->myDestX = 0.0;
  obj->myDestY = 0.0;

  obj->skipNavigation = NO;

  return obj;
}


///////////////////////////////////////////////////
//
// drop
//
////////////////////////////////////////////////////
- (void) drop {

  [acceleration drop];
  [flockCenter  drop];
  [yourCalcPosition  drop];
  [flockVelocity  drop];
  [super drop];

}

- createEnd {

  return [super createEnd];

}


//////////////////////////////////////////////////////////
//
// init
//
////////////////////////////////////////////////////////
- init: (int) id : (int) type
      : (id <Vector>) p
      : (id <Vector>) v {

    [super init: id : type : p : v];
 

    return self;

}

///////////////////////////////////////////////////////////////
//
// visible
//
//////////////////////////////////////////////////////////////
//- (double) visible: (SimObject *)b {
- visible: (SimObject *)b {

  double res;
  int dx, dy;

  // find out if the boid b is within our field of view
  [[calculation init: b->position] sub: position];
  res = [calculation getLength];

  if (res > worldX/2) {    // correct for torus world


     [yourCalcPosition init: b->position];

     dx = [calculation getX]; if (dx<0) dx = -dx;
     dy = [calculation getY]; if (dy<0) dy = -dy;
    
     if (dx>worldX/2) {

        if ([yourCalcPosition getX] < [position getX])
            [yourCalcPosition setX: [yourCalcPosition getX] + worldX];
        else
            [yourCalcPosition setX: [yourCalcPosition getX] - worldX];

     } //if dx


    if (dy>worldY/2) {

        if ([yourCalcPosition getY] < [position getY])
	    [yourCalcPosition setY: [yourCalcPosition getY] + worldY];
        else
	    [yourCalcPosition setY: [yourCalcPosition getY] - worldY];

     } //if dy

  }  //if res


  return self;

}



///////////////////////////////////////////////////
//
// getProbeLength
//
///////////////////////////////////////////////////
- (double) getProbeLength
{
  double maxScale = 5.0;

  // When we're at maxVelocity, scalefactor = maxScale.
  // When our velocity is 0, scalefactor = 1.
  // Linearly scale in between.
  double scaleFactor = ((maxScale-1.0)/(paramSpace->maxVelocity))*[velocity getLength]+1.0;

  return 10 * (paramSpace->bodyRadius) * scaleFactor;

}




/////////////////////////////////////////////////
//
// updateVisibilityList
//
/////////////////////////////////////////////////
- updateVisibilityList {

  id <Index> index;
  SimObject *member;
  int bType;
  double dist;
  double prevDist=LARGEINT;

  unsigned int flockCount=0;


  //  printf("Boid\tupdateVisibilityList\n");

  index  = [[model getObjectList] listBegin: scratchZone];

  [flockCenter init];
  [flockVelocity init];

  closestBoid = nil;
 

  for (member = [index next]; [index getLoc] == Member; member = [index next]) {

   //
   // calculate the yourCalcPosition vector
   //
   //[self visible: member];

   [[calculation init: [member getPosition]] sub: position];
   dist = [calculation getLength];
 

   if (dist < (paramSpace->interactionDist) && [calculation angle: velocity] < ((paramSpace->fieldOfView) * PI)) {
    

      if(member != self)  {

          bType = [member getObjectType];

          if (bType == objectType) { 
  
 
	         [flockCenter add: [member getPosition]];
	         [flockVelocity add: [member getVelocity]];
                 flockCount++;



                 //
                 // Now find the boid closest to us
                 //
                 if(closestBoid == nil) {
            
                        closestBoid = (Boid *) member;

                 }
                 else {

                      closestBoid = (prevDist < dist) ? closestBoid : (Boid *) member;
                      prevDist = (prevDist < dist) ? prevDist : dist; 
                      
                }


      
          }  // if bType

      } //if member

     } //if dist

  } //for member

  if(index != nil) {
  
      [index drop];

  }

  if(flockCount) {

    [flockCenter div: (double) flockCount];
    [flockVelocity div: (double) flockCount];

  }
  else  {

    [flockCenter init: -1.0: -1.0];

  }

  //  printf("Boid\tupdateVisibilityList done.\n");
  return self;
}


////////////////////////////////////////////////////////
//
// accumulate
//
///////////////////////////////////////////////////////
- (double) accumulate: (id <Vector>)valueToAdd
{
  double newLength;
  if ([valueToAdd getLength] > 1.0) {

      [valueToAdd normalize];

  }

  [acceleration add: valueToAdd];

  newLength = [acceleration getLength];

  if (newLength > 1.0) {

       [acceleration normalize];

  }

  return newLength;
}



///////////////////////////////////////////////////
//
// navigator
//
//////////////////////////////////////////////////
- navigator
{

  if(!skipNavigation)  {

      double length = 0.0;

      // Calculate the visibility matrix so that visibility computations are
      // much more efficient.

      //  printf("Boid\tnavigator\n");
      [self updateVisibilityList];

      [acceleration init];
        length = [self accumulate: [self flockCentering]];
      if (length < 1.0)
        length = [self accumulate: [self velocityMatching]];
      //if (length < 1.0)
         //length = [self accumulate: [self collisionAvoidance]];
      //if (length < 1.0)
        //length = [self accumulate: [self predatorAvoidance]];
      if (length < 1.0)
        length = [self accumulate: [self maintainingCruisingDistance]];
      if (length < 1.0)
        length = [self accumulate: [self wander]];

  // should be done with a swarm and a scedule, no?

  // printf("acceleration:\t"); [acceleration print];
  
  // IMPORTANT:
  // Since the FlockCentering, CollisionAvoidance, and VelocityMatching modules
  // return a vector whose magnitude is a percentage of the maximum acceleration,
  // we need to convert this to a real magnitude before we hand it off to the Flight
  // module. 
  // Remember, maxAcceleration is in terms of a fraction (0.0 to 1.0) of maxVelocity

      [acceleration mult: (paramSpace->maxAcceleration) * (paramSpace->maxVelocity)];
      //  printf("Boid\tnavigator\n");

  } //if skipNavigation

else  {  // If sendToX was used on this fish then stop when it's there.

  double xDiff;
  double yDiff;

  xDiff = myDestX - [position getX];
  yDiff = myDestY - [position getY];

  if (xDiff < 0.0) xDiff = -xDiff;
  if (yDiff < 0.0) yDiff = -yDiff;

  if ((xDiff < 10) && (yDiff < 10)) [velocity init: 0 : 0];

} //else

  return self;
}



/////////////////////////////////////////////////
//
// collisionAvoidance
//
// The class is broken with respect to
// collisionAvoidance don't use unless you fix it
//
/////////////////////////////////////////////////
- (id <Vector>)collisionAvoidance {
  SimObject *obs;
  double mag;

  [calculation init];

  //if ((obs = [visibleBoids[OBSTACLE] getLast]) != nil) {
  if ((obs = closestBoid) != nil) {
    // Obstacle with lowest priority == closest seen
  
    mag = 1.0 - [obs avoid: position with: calculation]/[self getProbeLength];

    // printf("Avoid:\t"); [calculation print];

    if (mag < 0.001) {

         [calculation init]; // ignore objects far away

    }
    else {

        [calculation setLength: mag];
      
        if(0) {
 
           fprintf(stderr, "Avoid:\t"); 
           [calculation print];

       }

    }
  }

  return calculation; 
}


/////////////////////////////////////////////////
//
// maintainingCruisingDistance
//
/////////////////////////////////////////////////
- (id <Vector>)maintainingCruisingDistance
{
  //Boid *boid;
  double dist;

  [calculation init];

  if (closestBoid != nil) {

     // Boid with lowest priority == closest seen
     [[calculation init: [closestBoid getPosition]] sub: position];
     dist = [calculation getLength];

     //if (dist > cruiseDistance) {
     if (dist > (paramSpace->interactionDist)) {

        [calculation setLength: 0.1];
    }
    else {
     
        [calculation setLength: -0.1];

    }

  } //if closestBoid

  return calculation;
}



/////////////////////////////////////////////////////
//
// velocityMatching
//
////////////////////////////////////////////////////
- (id <Vector>)velocityMatching
{
  //Boid *boid;   

  [calculation init];

  //if (closestBoid != nil) {

      // Boid with lowest priority == closest seen
      [calculation init: flockVelocity];
 
      [calculation mult: (paramSpace->velocityMatchStrength)]; // importance factor of velocityMatching

  //}

  return calculation;
}



/////////////////////////////////////////////////////
//
// flockCentering
//
/////////////////////////////////////////////////////
- (id <Vector>)flockCentering
{
  [calculation init: -1.0: -1.0];

  if ([calculation eq: flockCenter]) { // sybol: no others

      [calculation init];

  }
  else {

      [[[calculation init: flockCenter] sub: position] mult: (paramSpace->desiredCruisingSpeed)];

  }

  return calculation;
}





/////////////////////////////////////////////////////////
//
// predatorAvoidance
//
// This method is broken
// visible returns a vector
//
////////////////////////////////////////////////////////
- (id <Vector>)predatorAvoidance
{
  Boid *obj;
  double mag, dist;


  [calculation init];

  return calculation;

  // avoid agents with objectType = [self objectType]+1

  switch (objectType) {
  default: 
           //[InternalError raiseEvent: "ERROR: BOID has no type\n"];
           //break;

  case PREY:
       if ((obj = [visibleBoids[PREDATOR] getLast]) != nil) { // lowest priority == closest seen
           //dist = [self visible: obj];
           [[calculation init: position] sub: [obj getPosition]];
           if (dist < 0) { // pretty far away
	       mag = 1.0 - [calculation getLength]/[self getProbeLength]; }
           else {
	       mag = 1.2 * (1.0 - dist/[self getProbeLength]);
           }

           [[calculation sub:[obj getVelocity]] setLength: mag]; // go the other way
       }

    break;


  case PREDATOR:
      if ((obj = [visibleBoids[PREY] getLast]) != nil) { // lowest priority == closest seen
          [[calculation init: [obj getPosition]] sub: position]; // vector towards PREY
          mag = 1.2 * (1.0 - [calculation getLength]/[self getProbeLength]);
          [calculation setLength: mag];
      }
  
      break;
     

  }  //switch

  return calculation;
}


/////////////////////////////////////////////////////////////
//
// step
//
/////////////////////////////////////////////////////////////
- step {

  double x, y;

  //  double dt = 1.0;
  
  //  [position print];

  [super step];     // p' = p0 + v0 * dt

  [self navigator]; // calculate new acceleration vector

  // new position p = p' + 1/2 * dt^2 * a
  [position add: [[calculation init: acceleration] mult: 0.5]];

  // new velocity = v0 + a * dt
  [velocity add: acceleration];

  if ([velocity getLength] > (paramSpace->maxVelocity)) // cap off at top speed
    [velocity setLength: (paramSpace->maxVelocity)];

  x = [position getX];
  y = [position getY];

  if (x<0.0) { [position setX: -x]; [velocity setX: -[velocity getX]]; }

  if (x>worldX)  { [position setX: (2*worldX -  x)]; [velocity setX: -[velocity getX]];}

  if (y<0.0) { [position setY: -y]; [velocity setY: -[velocity getY]]; }

  if (y>worldY)  { [position setY: (2*worldY -  y)]; [velocity setY: -[velocity getY]]; } 

   

  return self;
}



/////////////////////////////////////////////////////////
//
// wander
//
/////////////////////////////////////////////////////////
- (id <Vector>)wander {
  [[calculation init: velocity]
    mult: ([velocity getLength] - (paramSpace->desiredCruisingSpeed)) / (paramSpace->maxVelocity)];

  return calculation;
}





////////////////////////////////////////////////////
//
////           SEND
//////
////////
///////////////////////////////////////////////////
- sendToX: (double) aLocationX 
        Y: (double) aLocationY {

  double dirX=0;
  double dirY=0;


  fprintf(stderr, "BOID >>>> sendToX:Y: aLocationX = %d \n", (int) (aLocationX + 0.5));
  fprintf(stderr, "BOID >>>> sendToX:Y: aLocationY = %d \n", (int) (aLocationY + 0.5));
  fflush(0);

  myDestX = aLocationX;
  myDestY = aLocationY;

  dirX = aLocationX - [position getX];
  dirY = aLocationY - [position getY];

  fprintf(stderr, "BOID >>>> sendToX:Y: aLocationX = %d \n", (int) (aLocationX + 0.5));
  fprintf(stderr, "BOID >>>> sendToX:Y: dirX = %f \n", dirX);
  fprintf(stderr, "BOID >>>> sendToX:Y: aLocationY = %d \n", (int) (aLocationY + 0.5));
  fprintf(stderr, "BOID >>>> sendToX:Y: dirY = %f \n", dirY);
  fflush(0);


  [acceleration init: 0 : 0];

  [calculation init: dirX : dirY];

  [velocity setDirection: calculation];
  //[velocity add: acceleration];

  skipNavigation = YES;

  return self;

}





@end

