// ModelSwarm.m
//--------------------------------------------------------------------

#import <activity.h>
#import <collections.h>
#import "ModelSwarm.h"

//--------------------------------------------------------------------

@implementation ModelSwarm

// These methods provide access to the objects inside the ModelSwarm.
// These objects are the ones visible to other classes via message call.
// In theory we could just let other objects use Probes to read our state,
// but message access is frequently more convenient.

//--------------------------------------------------------------------

+ createBegin: aZone
{

   ModelSwarm *obj;
   id <ProbeMap> probeMap;

TRACE1(printf("\n%8X ModelSwarm - entry createBegin\n",(int) self);)

   // in createBegin, we set up the simulation parameters
   // First, call our superclass createBegin - the return value is the
   // allocated Swarm object.

   obj = [super createBegin: aZone];

   // Now fill in various simulation parameters with default values.

   obj->numberOfAgents      = 1;
   obj->numberOfEvents      = 4;
   obj->numberOfActions     = 4;
   obj->numberOfSituations  = 16;
   obj->numberOfRules       = 32;
   obj->maxNumberOfMessages = 1;
   obj->goldsFlag           = 0;
   obj->winningsTreshold    = 3000;

   // Build a customized probe map. Without a probe map, the default
   // is to show all variables and messages. Here we choose to
   // customize the appearance of the probe, give a nicer interface.

   probeMap = [EmptyProbeMap createBegin: aZone];
   [probeMap setProbedClass: [self class]];
   probeMap = [probeMap createEnd];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "numberOfAgents" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "numberOfEvents" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "numberOfActions" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "numberOfSituations" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "numberOfRules" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "maxNumberOfMessages" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "goldsFlag" inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable:
    "winningsTreshold" inClass: [self class]]];

   // Now install our custom probeMap into the probeLibrary.

   [probeLibrary setProbeMap: probeMap For: [self class]];

TRACE1(printf("%8X ModelSwarm - exit createBegin %8X\n\n",
       (int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------

- createEnd
{

   id obj;

TRACE1(printf("\n%8X ModelSwarm - entry createEnd\n",(int) self);)

   eyeCatcher[0] = 'M';
   eyeCatcher[0] = 'O';
   eyeCatcher[0] = 'D';
   eyeCatcher[0] = 'S';

   obj = [super createEnd];

TRACE1(printf("%8X ModelSwarm - exit createEnd %8X\n\n",
       (int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------

- buildObjects
{

   // Here we create instances for objects before createEnd, for each,
   // the initial topic values are set using a specific method

   char * parmSet = "ClassifierParm.dat";

   // Following statement is to enable if you want use pre-codified rules

//   char * ruleSet = "DataWarehouse.dat";
   Dump           * dump;
   Shuffler       * shuffler;
   Lottery        * lottery;
   ClassifierParm * aClassifierParm;
   RuleMaker      * aRuleMaker;
   RuleMaster     * aRuleMaster;
   DataWarehouse  * aDataWarehouse;
   Interface      * anInterface;
   Agent          * anAgent;
   int i;

TRACE1 (printf("\n%8X ModelSwarm - entry buildObjects \n",(int) self);)

   dump       = [Dump  createBegin: self];
   dump       = [dump createEnd];

   shuffler    = [Shuffler createBegin: self];
   shuffler    = [shuffler createEnd];

   lottery   = [Lottery createBegin: self];
   [lottery setNumberOfSituations: numberOfSituations];
   [lottery setNumberOfActions: numberOfActions];
   [lottery setWinningsTreshold: winningsTreshold];
   lottery   = [lottery createEnd];

   aClassifierParm = [ClassifierParm createBegin: self];
   aClassifierParm = [aClassifierParm createEnd];

   //let's load basic parameter's value from file ClassifierParm.dat

   [aClassifierParm loadFromFile: (char *) parmSet];

   //let's ovveride loaded parms with values contained in probeMap

   [aClassifierParm setGeneLength: numberOfEvents];
   [aClassifierParm setNumberOfEffectors: numberOfActions];
   [aClassifierParm setEffectorsFlag: goldsFlag];
   [aClassifierParm setNumberOfRules: numberOfRules];
   [aClassifierParm setMaxNumberOfMessages: maxNumberOfMessages];

   aRuleMaker  = [RuleMaker  createBegin: self];
   aRuleMaker  = [aRuleMaker createEnd];
   [aRuleMaker setDump: dump];
   [aRuleMaker setShuffler: shuffler];

   aRuleMaster = [RuleMaster createBegin: self];
   [aRuleMaster setRuleMaker: aRuleMaker];
   aRuleMaster = [aRuleMaster createEnd];
   [aRuleMaster setDump: dump];
   [aRuleMaster setShuffler: shuffler];

   // here we create a bunch of agents and dataWarehouses; each agent
   // needs an own dataWarehouse

   agentList = [List create: self];

   for (i=0;i<numberOfAgents;i++)
   {

      aDataWarehouse = [DataWarehouse createBegin: self];
      [aDataWarehouse setClassifierParm: aClassifierParm];
      aDataWarehouse = [aDataWarehouse createEnd];

//Methods setAtRandom or loadFromFile need data from classifierParm
//obtained in createEnd

      [aDataWarehouse setAtRandom];
//    [aDataWarehouse loadFromFile: (char *) ruleSet];

      anInterface = [Interface createBegin: self];
      [anInterface setEventsToMap: numberOfEvents];
      anInterface = [anInterface createEnd];

      anAgent = [Agent createBegin: self];

      [anAgent setRuleMaster:    aRuleMaster];
      [anAgent setLottery:       lottery];
      [anAgent setDataWarehouse: aDataWarehouse];
      [anAgent setInterface:     anInterface];
      [anAgent setNumber:        i];

      anAgent = [anAgent createEnd];

      [agentList addLast: anAgent];

   }

TRACE1 (printf("%8X ModelSwarm - exit buildObjects %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- buildActions
{

   // Create the list of simulation actions. We put these in an action
   // group, because we want these actions to be executed in a specific
   // order, but these steps should take no (simulated) time. The
   // M(foo) means "The message called <foo>". You can send a message
   // To a particular object, or ForEach object in a collection.

TRACE1(printf("\n%8X ModelSwarm - entry buildActions\n",(int) self);)

   modelActions = [ActionGroup create: self];
   [modelActions createActionForEach: agentList    message: M(step)];

   // Then we create a schedule that executes the modelActions. modelActions
   // is an ActionGroup, by itself it has no notion of time. In order to
   // have it executed in time, we create a Schedule that says to use
   // the modelActions ActionGroup at particular times.
   // This schedule has a repeat interval of 1, it will loop every time step.
   // The action is executed at time 0 relative to the beginning of the loop.
   // This is a simple schedule, with only one action that is just
   // repeated every time. See mousetraps for more complicated schedules.

   modelSchedule = [Schedule createBegin: self];
   [modelSchedule setRepeatInterval: 1];
   modelSchedule = [modelSchedule createEnd];
   [modelSchedule at: 0 createAction: modelActions];

TRACE1(printf("%8X ModelSwarm - exit buildActions %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- activateIn: swarmContext
{

   // Here, we activate the swarm in the context passed in
   // Then we activate our schedule in ourselves

TRACE1(printf("\n%8X ModelSwarm - entry activateIn\n",(int) self);)

   [super activateIn: swarmContext];
   [modelSchedule activateIn: self];

TRACE1(printf("%8X ModelSwarm - exit activateIn %8X\n\n",
              (int) self,(int) [self getSwarmActivity]);)

   return [self getSwarmActivity];

}

//--------------------------------------------------------------------

- getAgentList
{

TRACE1(printf("\n%8X ModelSwarm - entry getAgentList\n",(int) self);)
TRACE1(printf("%8X ModelSwarm - exit getAgentList %8X\n\n",
              (int) self,(int) agentList);)

   return agentList;

}

//--------------------------------------------------------------------
@end
