// Lottery.m
//--------------------------------------------------------------------

#import "Lottery.h"

//--------------------------------------------------------------------

@implementation Lottery

//--------------------------------------------------------------------
//here we set initial values of several variables

- createEnd
{
//   int i;
   id  obj;

TRACE2(printf("\n%8X Lottery - entry createEnd\n",(int) self);)

   eyeCatcher[0]='L';
   eyeCatcher[1]='O';
   eyeCatcher[2]='T';
   eyeCatcher[3]='T';
   winnings = 0;
   add      = 1;

   obj = [super createEnd];

TRACE2(printf("%8X Lottery - exit createEnd %8X\n\n",
       (int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------

- setNumberOfSituations: (int) nS
{

TRACE2(printf("\n%8X Lottery - entry setNumberOfSituations: %d\n",
       (int) self,nS);)

   numberOfSituations = nS;

TRACE2(printf("%8X Lottery - exit setNumberOfSituations %8X\n\n",
       (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setNumberOfActions: (int) nA
{

TRACE2(printf("\n%8X Lottery - entry setNumberOfActions: %d\n",
              (int) self,nA);)

   numberOfActions = nA;

TRACE2(printf("%8X Lottery - exit setNumberOfActions %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setWinningsTreshold: (int) wT
{

TRACE2(printf("\n%8X Lottery - entry setWinningsTreshold: %d\n",
              (int) self,wT);)

   winningsTreshold = wT;

TRACE2(printf("%8X Lottery - exit setWinningsTreshold %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------
//here we give an initial value to an agent and then we make a
//manipulation of this value based upon the rules we are going to test

- (int) getInfoFor: (int) cN
{

   int i;

TRACE2(printf("\n%8X Lottery - entry getInfoFor: %d\n",(int) self,cN);)

   //To simulate several situations let's start with a random number
   //between 0 and the number of situations we would test.
   //Then we modify the number to generate a new one that will be the
   //number of action proposed by the agent, i. e. by the agent's
   //ruleMaster.
   //To allow correct answers for several situations let's compute the
   //module of the ratio between the initial random number and the
   //number of actions: this way we can easy generate a lot of
   //situations and correct actions to do.
   //If we set situations = actions for each situations we will have
   //a correct action, unless we will have correct actions for several
   //situations accordingly to the module of the ratio
   //situations/actions.
   //The correct answer is computed as natural number following the
   //result of computation. This way it's very easy to verify the
   //generated rules reading them as binary number.
   //This method will return the random number, the verification
   //method (getWinnings) will compare the result of manipulation
   //stored in customTarget array with the bid proposed by di agent
   //this way the user will be able to modify the workbanch behaviour,
   //with a few intervention on the code of this method.
   //Random generation is limited to situations - 1 to allow binary
   //representation, remember that 16 binary numbers to be stored in
   //4 position have to be 0,1,....15 not 1,2,...16.

   i = [uniformIntRand getIntegerWithMin: 0
                                 withMax: numberOfSituations-1];

   if ((winnings > winningsTreshold) && (winningsTreshold > 0))
   {

      add = (add+1) % 2;
      winnings = 0;
      printf("\n Lottery is switching manipulation bias = %d\n",add);

   }

   customTarget[cN] = (i+add) % numberOfActions;

// if (numberOfActions < numberOfSituations)
// customTarget[cN] = i % numberOfActions;

TRACE2(printf("%8X Lottery - exit getInfoFor %d\n\n",
                 (int) self,i);)

   return i;

}

//--------------------------------------------------------------------
//here we return reward of the agent's bid. For this value double type
//is used to allow users to try also real values with few modification
//of this routine.

- (double) getWinningsFor: (int) cN withBid: (int) cB
{

   double w;

TRACE2(printf("\n%8X Lottery - entry getWinningsFor: %d withBid: %d\n",
              (int) self,cN,cB);)

   w = 0;
   if (customTarget[cN] == cB) w = 1;

   winnings = (winnings + w)*w;


TRACE2(printf("%8X Lottery - exit getWinningsFor %f\n\n",(int) self,w);)

   return w;

}

//--------------------------------------------------------------------
@end
