// Interface.m
//--------------------------------------------------------------------

#import "Interface.h"

//--------------------------------------------------------------------

@implementation Interface

//--------------------------------------------------------------------
//Here we set initial values of counters and constant eyeCatcher
//that will be useful to find the area in a memory-dump

- createEnd
{

   id obj;

TRACEC(printf("\n%8X Interface - entry createEnd\n",(int) self);)

   eyeCatcher[0] = 'I';
   eyeCatcher[0] = 'N';
   eyeCatcher[0] = 'T';
   eyeCatcher[0] = 'F';

   obj = [super createEnd];

TRACEC(printf("%8X Interface - exit createEnd %8X\n\n",
       (int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------

- setEventsToMap: (int) eN
{

TRACEC(printf("\n%8X Interface - entry setEventsToMap: %d\n",(int) self,eN);)

   eventsToMap = eN;

TRACEC(printf("%8X Interface - exit setEventsToMap %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- (char *) getEventsMap
{

TRACEC(printf("\n%8X Interface - entry getEventsMap\n",(int) self);)
TRACEC(printf("%8X Interface - exit getEventsMap %8X\n\n",
              (int) self,(int) &eventsMap[0]);)

   return &eventsMap[0];

}

//--------------------------------------------------------------------

- setSuggestionMap: (char *) sM
{

   int i;        

TRACEC(printf("\n%8X Interface - entry setSuggestionMap: %8X\n",
              (int) self,(int) sM);)

   for(i=0;i<eventsToMap;i++) suggestionMap[i] = sM[i];

TRACEC(printf("%8X Interface - exit setSuggestionMap %8X\n\n",
              (int) self,(int) self);)

   return self;

}
                                                       
//--------------------------------------------------------------------

- encode: (int) n
{

   double w;
   int i,j;

TRACEC(printf("\n%8X Interface - entry encode: %d\n",(int) self,n);)

   //For this kind of agents mapping events consist, simply, in
   //a binary translation of the number obtained from the lottery,
   //to made inputs easy to read we will justify to left the
   //translation that involve agent's knowledge of the number of
   //events to handle.

   i = n;

   for(j=0;j<eventsToMap;j++)
   {

      w = pow(2,eventsToMap-j-1);
      if (i >= w) {eventsMap[j] = '1';i=i-w;}
      else eventsMap[j] = '0';

   }

TRACEC(printf("%8X Interface - exit encode %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- (int) decode
{

   double w=0;
   int j,i;

TRACEC(printf("\n%8X Interface - entry decode\n",(int) self);)

   for(j=0;j<eventsToMap;j++)
   {
      i = 0;
      if(suggestionMap[j] == '1') i = 1;
      w = w + (pow(2,eventsToMap-j-1))*i;

   }

   j = (int) w;

TRACEC(printf("%8X Interface - exit decode %d\n\n",(int) self,j);)

   return j;

}

//--------------------------------------------------------------------
@end
