// Effector.m
//-------------------------------------------------------------------

#import"Effector.h"

@implementation Effector

//-------------------------------------------------------------------
//here we create, as made for rules, a partnerList to store partners,
//i. e. rules that have made messages whose body is matching the
//body (condition part) of the effector. This effector can remember
//them to pay if it is selected to fire.

- createEnd
{

   id obj;

TRACEB (printf("\n%8X Effector - entry createEnd\n",(int) self);)

   eyeCatcher[0]= 'E';
   eyeCatcher[0]= 'F';
   eyeCatcher[0]= 'F';
   eyeCatcher[0]= 'R';
   partnerList  = [List create: [self getZone]];

   obj = [super createEnd];

TRACEB (printf("%8X Effector - exit createEnd %8X\n\n",
        (int) self,(int) obj);)

   return obj;

}

//-------------------------------------------------------------------
//When an effector is dropped, also dropping of its partnerList is
//required.

- (void) drop
{

   id obj;

TRACEB (printf("\n%8X Effector - entry drop\n",(int) self);)

   [partnerList drop];

   obj = [super createEnd];

TRACEB (printf("%8X Effector - exit drop\n\n",(int) self);)

   return;

}

//-------------------------------------------------------------------

- setBody: (char *) aS
{

   int i;

TRACEB (printf("\n%8X Effector - entry setBody: %8X\n",
        (int) self,(int) aS);)
TRACEB ([dump dumpFromAddress: (id) aS forLength: length];)

   for(i=0;i<length;i++) body[i] = aS[i];

TRACEB (printf("%8X Effector - exit setBody %8X\n\n",
        (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- setLength: (int) ll
{

//   int i;

TRACEB (printf("\n%8X Effector - entry setLength: %d\n",(int) self,ll);)

   length      = ll;

TRACEB (printf("%8X Effector - exit setLength %8X\n\n",
         (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- setSuggestion: (int) su
{

TRACEB (printf("\n%8X Effector - entry setSuggestion: %d\n",(int) self,su);)

   suggestion  = su;

TRACEB (printf("%8X Effector - exit setSuggestion %8X\n\n",
        (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- setDump: du
{

TRACEB (printf("\n%8X Effector - entry setDump: %8X\n",
        (int) self,(int) du);)

   dump = du;

TRACEB (printf("%8X Effector - exit setDump %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- setPartner: ru
{

TRACEB (printf("\n%8X Effector - entry setPartner: %8X\n",
        (int) self,(int) ru);)

  [partnerList addLast: ru];
  support = support + [ru getEBid];

TRACEB (printf("%8X Effector - exit setPartner %8X\n\n",
               (int) self,(int) self);)

   return self;

}


//-------------------------------------------------------------------
//Support of an effector is the sum of partner's effective bids.

- (double) getSupport
{

TRACEB (printf("\n%8X Effector - entry getSupport\n",(int) self);)
TRACEB (printf("%8X Effector - exit getSupport %f\n\n",(int) self,support);)

   return support;

}

//-------------------------------------------------------------------
//suggestion is the number of actions that this effector represents

- (int) getSuggestion
{

TRACEB (printf("\n%8X Effector - entry getSuggestion\n",(int) self);)
TRACEB (printf("%8X Effector - exit getSuggestion %d\n\n",
               (int) self,suggestion);)

   return suggestion;

}

//-------------------------------------------------------------------

- (char *) getBody
{

TRACEB (printf("\n%8X Effector - entry getBody\n",(int) self);)
TRACEB (printf("%8X Effector - exit getBody %8X\n\n",
                  (int) self,(int) &body[0]);)
TRACEB ([dump dumpFromAddress: (id) &body[0] forLength: length];)

   return &body[0];

}


//-------------------------------------------------------------------

- (int) matchMessage: (Messag *) me
{

   int i=-1;
   int match=0;
   char * string;
   Rule * aRule;

TRACEB (printf("\n%8X Effector - matchMessage: %8X\n",(int) self,(int) me);)

   string = [me getText];

   for(i=0;i<length;i++) if((body[i] == '#') ||
                            (string[i]    == '#'  ) ||
                            (body[i] == string[i])) match++;

   if (match == length)
   {

     aRule = [me getOwner];
     [partnerList addLast: aRule];
     support = support + [aRule getEBid];

   }

TRACEB (printf("%8X Effector - exit matchMessage %d\n\n",(int) self,match);)

   return match;

}

//-------------------------------------------------------------------
//Before each matching-phase al members are removed from the partner
//list and support value is set to zero.

- resetPartnerList
{

TRACEB (printf("\n%8X Effector - entry resetPartnerList\n",(int) self);)

   [partnerList removeAll];
   support = 0;

TRACEB (printf("%8X Effector - exit resetPartnerList %8X\n\n",
        (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------
//if an effector gets the permission to fire it have to pay rules
//that are fired messages matching it. Effector pay simply a part
//of the reward that is received from the agent.

- payToPartners: (double) rV
{

   int    i,numberOfPartners;
   double amount;

TRACEB (printf("\n%8X Effector - entry payToPartners: %f\n",(int) self,rV);)

   numberOfPartners = [partnerList getCount];
   amount           = rV / numberOfPartners;

   for(i=0;i<numberOfPartners;i++)
   {

      [[partnerList atOffset: 0] cash: amount];

   }

TRACEB (printf("%8X Effector - exit payToPartners %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- print
{

   int i,j;

   printf("%8X suggestion %d\n",(int) self,suggestion);

   for(i=0;i<length;i++) printf("%c",body[i]);
   printf("\n");

   j = [partnerList getCount];
   printf("My partnerList contains %d entries for:\n",j);
   for(i=0;i<j;i++) printf("%8X\n",(int) [partnerList atOffset: i]);

   return self;

}

//-------------------------------------------------------------------

- printPartners
{

   [partnerList forEach: M(print)];

   return self;

}

//-------------------------------------------------------------------
@end
