// ClassifierParm.h
//--------------------------------------------------------------------

#import <objectbase/SwarmObject.h>
#import <simtools.h>
#import "Trace.h"

//--------------------------------------------------------------------

@interface ClassifierParm: SwarmObject
{

   //external files

   char eyeCatcher[4];
   id <InFile>  parmSet;
   id <OutFile> parmLog;

   //General parameters

   float  wildCardRate,confidence,initialStrength;
   int    numberOfRules,numberOfEffectors,geneLength;

   //Parameters to modify classifier system's behaviour

   int    maxNumberOfMessages,effectorsFlag;

   //Parameters to handle flow of strength

   float  bidTaxRate,lifeTaxRate,bidRatio,linearBid1,linearBid2,
          effectiveLinearBid1,effectiveLinearBid2,bidSigma,bidMu;

   //Parameters to handle genetic manipulation

   float  evolutionRate,turnoverRate,crossoverRate,mutationRate,
          crowdingRate,crowdingFactor;

}
//--------------------------------------------------------------------
-         createEnd;

- (int)   getNumberOfRules;
- (int)   getNumberOfEffectors;
- (int)   getGeneLength;
- (int)   getMaxNumberOfMessages;
- (int)   getEffectorsFlag;
- (float) getWildCardRate;
- (float) getConfidence;
- (float) getInitialStrength;

- (float) getBidTaxRate;
- (float) getLifeTaxRate;
- (float) getBidRatio;
- (float) getLinearBid1;
- (float) getLinearBid2;
- (float) getEffectiveLinearBid1;
- (float) getEffectiveLinearBid2;
- (float) getBidSigma;
- (float) getBidMu;

- (float) getEvolutionRate;
- (float) getTurnoverRate;
- (float) getCrossoverRate;
- (float) getMutationRate;
- (float) getCrowdingRate;
- (float) getCrowdingFactor;


- setNumberOfRules:       (int) nR;
- setNumberOfEffectors:   (int) nO;
- setGeneLength:          (int) gL;
- setMaxNumberOfMessages: (int) mM;
- setEffectorsFlag:       (int) eF;

-         loadFromFile: (char *) pF;

- print;

//--------------------------------------------------------------------
@end 
