// Agent.m
//--------------------------------------------------------------------

#import "Agent.h"

//--------------------------------------------------------------------

@implementation Agent

//--------------------------------------------------------------------
//Here we set initial values of counters and constant eyeCatcher
//that will be useful to find the area in a memory-dump

- createEnd
{

   id obj;

TRACE3(printf("\n%8X Agent - entry createEnd\n",(int) self);)

   eyeCatcher[0] = 'A';
   eyeCatcher[0] = 'G';
   eyeCatcher[0] = 'E';
   eyeCatcher[0] = 'N';

   winningsCounter = 0;

   obj = [super createEnd];

TRACE3(printf("%8X Agent - exit createEnd %8X\n\n",(int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------

- setRuleMaster: (RuleMaster *)  rM
{

TRACE3(printf("\n%8X Agent - entry setRuleMaster: %8X\n",
              (int) self,(int) rM);)

   ruleMaster = rM;

TRACE3(printf("%8X Agent - exit setRuleMaster %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setLottery: (Lottery *)  lo
{

TRACE3(printf("\n%8X Agent - entry setLottery: %8X\n",(int) self,(int) lo);)

   lottery = lo;

TRACE3(printf("%8X Agent - exit setLottery %8X\n\n",(int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setDataWarehouse: (id)  dW
{

TRACE3(printf("\n%8X Agent - entry setDataWarehouse: %8X\n",
              (int) self,(int) dW);)

   dataWarehouse = dW;

TRACE3(printf("%8X Agent - exit setDataWarehouse %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setInterface: (id)  an
{

TRACE3(printf("\n%8X Agent - entry setInterface: %8X\n",
       (int) self,(int) an);)

   interface = an;

TRACE3(printf("%8X Agent - exit setInterface %8X\n\n",
       (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setNumber: (int) nn
{

TRACE3(printf("\n%8X Agent - entry setNumber: %d\n",(int) self,nn);)

   number = nn;

TRACE3(printf("%8X Agent - exit setNumber %8X\n\n",(int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- (int) getWinnings
{

TRACE3(printf("\n%8X Agent - entry getWinnings\n",(int) self);)
TRACE3(printf("%8X Agent - exit getWinnings %d\n\n",
              (int) self,winningsCounter);)

   return winningsCounter;

}

//--------------------------------------------------------------------
//In each step the agent ask the lottery to a number, then tries to
//compute the result of the manipulation of the same number using
//services of the ruleMaster.
//To ask the ruleMaster the agent must encode the number as environ-
//mental status in the eventsMap where each event is coded as true
//or false.

- step
{

   double w;
   int i,j;

TRACE3(printf("\n%8X Agent - entry step\n",(int) self);)

   i = [lottery getInfoFor: number];

   [interface encode: i];

   //After coding the map ruleMaster is asked for advice that will,
   //simply, be the result of manipulation of the initial number.

// [ruleMaster getAdviceFor: self];
   [ruleMaster applyRuleTo: (DataWarehouse *) dataWarehouse
                      with: (id)              interface];

   //Advice obtained from ruleMaster is used as bid to the lottery
   //that will return an evaluation, we well use only 0 or 1 value,
   //the amount is stored in a double, so users can easily modify
   //rewards values using, also, real values.

   j = [interface decode];

   w = [lottery getWinningsFor: number withBid: j];

   if (w > 0) winningsCounter++;

   //Accordingly with the value obtained from lottery ruleMaster is
   //gave a reward.

   [ruleMaster setReward: w to: dataWarehouse];

TRACE3(printf("%8X Agent - exit step %8X\n\n",(int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- resetWinningsCounter
{

TRACE3(printf("\n%8X Agent - entry resetWinningsCounter\n",(int) self);)

   winningsCounter = 0;

TRACE3(printf("%8X Agent - exit resetWinningsCounter %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- printWinnings
{

   printf("Agent %d has won %d times in the latest period\n",
          number,winningsCounter);

   return self;

}

//--------------------------------------------------------------------

- printDataWarehouse
{

   [dataWarehouse print];

   return self;

}

//--------------------------------------------------------------------
@end
