#include <stdio.h>
#include <math.h>

main (int argc, char *argv[]) {
  
  int q, i, x, result, j, K, n, B;
  unsigned nbits;

  x = atoi(argv[1]);      /* the genome value */
  n = atoi(argv[2]);      /* number of bits */
  K = atoi(argv[3]);      /* number of connections per node */
  
  /*  for (q=0; q<x; q++) { */
  q = x;
  printf("for the genome %d it's bits are:\n", q);
  for (i=127; i>=0; i--) {        /* 16 bytes worth!! */
    result = getbit(q, i);
    printf("%d", result);
    if ((i % 32) == 0)
      printf("\n");
    if ((i % 4) == 0)
      printf("*");                /* print a character between genetic blocks */
  } 
  printf("\n");  

  /* read off the genome in B x n-bit K-tuples */
  /* where K is the number of connections in genome */

  B = ldexp(1, n);    /* number of nodes */
  printf("there are %d Boolean nodes, requiring %d bits of genetic material\n", B, n);

  for (i = 0; i < B; i++) {        /* for each Boolean node */
    for (j = 0; j < K; j++) {      /* for each connection */
      
      printf("getting code for the %d-th connection\n", j);
      nbits = getbits(q, ((K*i+j+1)*n - 1), n);
      printf("the %d-th %d bits of %d are: %u\n", (K*i+j), n, q, nbits); 

    }
  }
  
}

int getbit (int x, int p) {
  return ( x >> p & 1 );
}

unsigned getbits(unsigned x, int p, int n)
{
  return (x >> (p+1-n)) & ~(~0 << n);
}
