// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Class that can serve up a colormap to BatchRaster when
// the GUI isn't running. Modified from code by Nelson:
// Benedikt Stefansson <benedikt@ucla.edu>. First version 7/23/97

//pj#import <swarmobject.h>
#import <objectbase.h>
//#import <tkobjc.h/Colormap.h>
#import <objectbase/Swarm.h>

@class BatchColormap;
@class RGB;

#define NUMNAMES 752
#define MAXCOLORS 256

@interface BatchColormap:Swarm {
  BOOL isSet[MAXCOLORS];
  RGB * xcolors[MAXCOLORS];
}

-(RGB *) rgbValue: (int) c; 
-(BOOL) setColor: (int) c ToName: (char *) colorName;
-(BOOL) setColor: (int) c ToGrey: (double) g;
-(BOOL) setColor: (int) c ToRed: (double) r Green: (double) g Blue: (double) b;
-(BOOL) colorIsSet: (int) c;

@end

@interface RGB: Swarm {
  unsigned red;
  unsigned green;
  unsigned blue;
}
-setRed: (unsigned) r Green: (unsigned) g Blue: (unsigned) b;
-(int) getRed;
-(int) getGreen;
-(int) getBlue;

@end

