// AgentModelSwarm.m
// Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Look for the "//   3d-specific:" string to find comments relevant
// only to this demo.

#import "AgentModelSwarm.h"
#import <simtools.h>

@implementation AgentModelSwarm

-getAgentList {
  return agentList;
}

-getSpace {
  return world;
}

+createBegin: (id) aZone {
  AgentModelSwarm * obj;
  ProbeMap * probeMap;

  obj = [super createBegin: aZone];

  obj->numAgents = 100;
  obj->worldXSize = 50;
  obj->worldYSize = 50;
  obj->worldZSize = 50;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "numAgents"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldXSize"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldYSize"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldZSize"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;
}

-createEnd {
  return [super createEnd];
}

-buildObjects {
  int incI;
  id randG;
  id uRand;

  randG = [[PMMLCG1 alloc] initSeed: 1234567890];
  uRand = [[[Uniform alloc] init] setGenerator: randG];

  [super buildObjects];
  
  world = [Discrete3d createBegin: [self getZone]];

  //   3d-specific:  Note that there is an extra coordinate
  //   3d-specific:  here, in contrast to the 2d worlds.
  [world setSizeX: worldXSize Y: worldYSize Z: worldZSize];
  world = [world createEnd];

  agentList = [List create: [self getZone]];
  
  for (incI = 0; incI < numAgents; incI ++) {
    int pos[3];
    Agent * anAgent;

    anAgent = [Agent createBegin: [self getZone]];

    pos[0] = [uRand rMin: 0 Max: worldXSize]; 
    pos[1] = [uRand rMin: 0 Max: worldYSize]; 
    pos[2] = [uRand rMin: 0 Max: worldZSize]; 

    [anAgent setSpace: world];


    //   3d-specific:  Same comment.  Extra coordinate.
    [anAgent setX: pos[0] Y: pos[1] Z: pos[2]];

    anAgent = [anAgent createEnd];

    [agentList addLast: anAgent];
  }

  return self;
}

-buildActions {
  [super buildActions];

  modelActions = [ActionGroup create: [self getZone]];
  [modelActions createActionForEach: agentList message: M(step)];

  modelSchedule = [Schedule createBegin: [self getZone]];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getSwarmActivity];
}

@end

