import swarm.Globals;
import swarm.defobj.Zone;
import swarm.objectbase.SwarmObjectImpl;
import swarm.random.BernoulliDist;
import swarm.random.BernoulliDistImpl;
import java.awt.Color;

public class Strategy {
    public String name = null;
    public Color color = Color.black;
    public float red = 0;
    public float green = 0;
    public float blue = 0;
    public int number = Integer.MIN_VALUE;
    public double i = Double.NaN;
    public double p = Double.NaN;
    public double q = Double.NaN;

    private BernoulliDist coin = null;
    public Strategy(Zone aZone) {
        coin = new BernoulliDistImpl(aZone,Globals.env.uniformDblRand.getGenerator());
    }

    public void set_number(int n) {
        number = n;
    }

    public void set_name(String n) {
        name = n;
    }

    public void set_color(Color c) {
        color = c;
    }

    public void set_ipq(double v_i, double v_p, double v_q) {
        i = v_i;
        p = v_p;
        q = v_q;
    }

    public int initial() {
        // Flip a coin to decide
        if (coin.getSampleWithProbability(i))
            return Payoffs.COOPERATE;
        else return Payoffs.DEFECT;
    }

    public int move(int o) {
        int result = -1;
        // Choose next move based on coin
        switch (o) {
        case Payoffs.COOPERATE:
            result = (coin.getSampleWithProbability(p) ? 
                      Payoffs.COOPERATE : Payoffs.DEFECT);
            break;
        case Payoffs.DEFECT:
            result = (coin.getSampleWithProbability(q) ?
                      Payoffs.COOPERATE : Payoffs.DEFECT);
            break;
        default:
            result = -1;
        }

        return result;
    }

    public boolean equals(Object o) {
        if (o == null) return false;
        else if (name == null) return super.equals(o);
        return name.equals(((Strategy)o).name);
    }

    public Color get_color() {
        return color;
    }

    public String get_name() {
        return name;
    }

    public int get_number() {
        return number;
    }
}
