import java.util.ArrayList;
import java.awt.Color;
import java.awt.Point;
public class Location extends Point {
    SwarmRaster grid = null;
    Object object = null;
    ArrayList neighbors = new ArrayList(8);
    boolean isNeighborCacheInvalid = true;

    public Location(SwarmRaster sr, int myX, int myY) {
        super(myX,myY);
        grid = sr;
    }

    public ArrayList get_neighbors() {
        if (isNeighborCacheInvalid) {
            neighbors.clear();
            Location n;
            if ((y-1 > 0) 
                && ((n=((Location)grid.getLocationAt(x,y-1))) != null))
                neighbors.add(n);         
            if ((y+1 < grid.getHeight())  
                && ((n=((Location)grid.getLocationAt(x,y+1))) != null))
                neighbors.add(n);         
            if ((x-1 > 0)                 
                && ((n=((Location)grid.getLocationAt(x-1,y))) != null))
                neighbors.add(n);         
            if ((x+1 < grid.getWidth())                 
                && ((n=((Location)grid.getLocationAt(x+1,y))) != null))
                neighbors.add(n);
            neighbors.trimToSize();
            isNeighborCacheInvalid = false;
        }
        return neighbors;
    }

    public Color get_color() {
        return ((Prisoner)object).get_color();
    }

    public int get_xpos() {
        return x;
    }

    public int get_ypos() {
        return y;
    }

    public void set_object(Object o) {
        object = o;
    }

    public Object get_object() {
        return object;
    }
}
