/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;

public class PlotApplet
extends Applet {
    private transient Plot _myPlot;

    public String getAppletInfo() {
        return "PlotApplet 2.0: A data plotter.\nBy: Edward A. Lee, eal@eecs.berkeley.edu and\n Christopher Hylands, cxh@eecs.berkeley.edu\n($Id: PlotApplet.java,v 1.29 1998/11/18 07:43:10 cxh Exp $)";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"background", "hexcolor value", "background color"}, {"foreground", "hexcolor value", "foreground color"}, {"dataurl", "url", "the URL of the data to plot"}, {"pxgraphargs", "args", "pxgraph style command line arguments"}};
        return pinfo;
    }

    public void init() {
        block12: {
            String dataurlspec;
            super.init();
            this.setLayout(new BorderLayout());
            if (this._myPlot == null) {
                this._myPlot = this.newPlot();
            }
            this.add("Center", this.plot());
            String widthspec = this.getParameter("width");
            int width = widthspec != null ? Integer.parseInt(widthspec) : 400;
            String heightspec = this.getParameter("height");
            int height = heightspec != null ? Integer.parseInt(heightspec) : 400;
            this.plot().setSize(width, height);
            this.plot().setButtons(true);
            Color background = Color.white;
            String colorspec = this.getParameter("background");
            if (colorspec != null) {
                background = PlotBox.getColorByName(colorspec);
            }
            this.setBackground(background);
            this.plot().setBackground(background);
            Color foreground = Color.black;
            colorspec = this.getParameter("foreground");
            if (colorspec != null) {
                foreground = PlotBox.getColorByName(colorspec);
            }
            this.setForeground(foreground);
            this.plot().setForeground(foreground);
            this.plot().setVisible(true);
            String pxgraphargs = null;
            pxgraphargs = this.getParameter("pxgraphargs");
            if (pxgraphargs != null) {
                try {
                    this.showStatus("Reading arguments");
                    this.plot()._documentBase = this.getDocumentBase();
                    this.plot().parsePxgraphargs(pxgraphargs);
                    this.showStatus("Done");
                }
                catch (CmdLineArgException e) {
                    System.err.println("PlotApplet: failed to parse `" + pxgraphargs + "': " + e);
                }
                catch (FileNotFoundException e) {
                    System.err.println("PlotApplet: file not found: " + e);
                }
                catch (IOException e) {
                    System.err.println("PlotApplet: error reading input file: " + e);
                }
            }
            if ((dataurlspec = this.getParameter("dataurl")) == null) break block12;
            try {
                this.showStatus("Reading data");
                URL dataurl = new URL(this.getDocumentBase(), dataurlspec);
                this.plot().read(dataurl.openStream());
                this.showStatus("Done");
            }
            catch (MalformedURLException e) {
                System.err.println(e.toString());
            }
            catch (FileNotFoundException e) {
                System.err.println("PlotApplet: file not found: " + e);
            }
            catch (IOException e) {
                System.err.println("PlotApplet: error reading input file: " + e);
            }
        }
    }

    public Plot newPlot() {
        return new Plot();
    }

    public Plot plot() {
        return this._myPlot;
    }
}

