/*$$
 * packages uchicago.src.*
 * Copyright (c) 1999, Trustees of the University of Chicago
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with 
 * or without modification, are permitted provided that the following 
 * conditions are met:
 *
 *	 Redistributions of source code must retain the above copyright notice,
 *	 this list of conditions and the following disclaimer.
 *
 *	 Redistributions in binary form must reproduce the above copyright notice,
 *	 this list of conditions and the following disclaimer in the documentation
 *	 and/or other materials provided with the distribution.
 *
 *	 Neither the name of the University of Chicago nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE TRUSTEES OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Nick Collier
 * nick@src.uchicago.edu
 *
 * packages cern.jet.random.*
 * Copyright (c) 1999 CERN - European Laboratory for Particle
 * Physics. Permission to use, copy, modify, distribute and sell this
 * software and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice appear in
 * supporting documentation. CERN makes no representations about the 
 * suitability of this software for any purpose. It is provided "as is" 
 * without expressed or implied warranty. 
 *
 * Wolfgang Hoschek
 * wolfgang.hoschek@cern.ch
 *$$*/
import java.awt.Point;
import java.util.Vector;
import java.util.Random;

import uchicago.src.sim.space.*;
import cern.jet.random.Uniform;

/**
 * The environment that the heat bugs inhabit. This uses a Diffuse2D to
 * diffuse the heat absorbed from the bugs.
 *
 * @author Swarm Project and Nick Collier
 * @version $Revision: 1.1.1.1 $ $Date: 2000/03/10 03:09:14 $
 */

public class HeatSpace extends Diffuse2D {

  public static final int HOT = 0;
  public static final int COLD = 1;

  private long maxHeat = Diffuse2D.MAX;
  public HeatSpace(double diffusionConstant, double evaporationRate,
                  int xSize, int ySize)
  {
    super(diffusionConstant, evaporationRate, xSize, ySize);
  }

  public void addHeat(int x, int y, int heat) {
    long heatHere = (long)this.getValueAt(x, y);

    if (heatHere + heat <= maxHeat) {
      heatHere += heat;
    } else {
      heatHere = maxHeat;
    }

    this.putValueAt(x, y, heatHere);
  }

  /**
   * Find the extreme hot or cold within this 9 cell neighborhood
   *
   * @return the extreme point
   */
  public Point findExtreme(int type, int x, int y) {

    long bestHeat = (long)this.getValueAt(x, y);

    // iterate through the space to find the extreme
    Vector heatList = new Vector();

    for (int py = y - 1; py <= y + 1; py++) {
      for (int px = x - 1; px <= x + 1; px++) {

        boolean hereIsBetter, hereIsEqual;

        long heatHere = (long)this.getValueAt(px, py);
        hereIsBetter = (type == COLD) ? (heatHere < bestHeat) :
                                        (heatHere > bestHeat);
        hereIsEqual = (heatHere == bestHeat);

        if (hereIsBetter) {
          Point p = new Point(px, py);
          heatList.clear();
          heatList.add(p);
          bestHeat = heatHere;
        }

        if (hereIsEqual) {
          Point p = new Point(px, py);
          heatList.add(p);
        }
      }
    }

    // choose a random index from within the list
    int index = Uniform.staticNextIntFromTo(0, heatList.size() - 1);
    Point bestPoint = (Point)heatList.elementAt(index);
    bestPoint.x = xnorm(bestPoint.x);
    bestPoint.y = ynorm(bestPoint.y);

    return bestPoint;
  }
}
