/****************************************************************
*
*                  Container World Project
*
*           (c) 2002-2004 Imperial College London
*
* $RCSfile: ImmutableIterator.java,v $
* $Revision: 1.1 $
* $Date: 2003/03/20 16:00:03 $
* $Author: marsha02 $
* Log: See end of file
*
****************************************************************/

package cosmic.util;

import java.util.Iterator;
import java.lang.RuntimeException;

/**
 * A class of iterator that does not allow modification of the underlying collection.
 * Author: James.A.Marshall@imperial.ac.uk
 *
 */

public class ImmutableIterator implements Iterator
{
	/** The iterator that the immutable iterator uses */
	private Iterator mIterator;

	/**
     * Returns true if the iterator has more elements.
     *
     * @return true if the iterator has more elements
     *
     */
	public boolean hasNext()
	{
		return mIterator.hasNext();
	}

	/**
     * Returns the next element in the iteration
     *
     * @return the next element in the iteration
     *
     */
	public Object next()
	{
		return mIterator.next();
	}

	/**
     * Removal through an immutable iterator is not permitted
     *
     * @return void
     *
     * @throws RuntimeException if called
     *
     */
	public void remove()
	{
		throw new RuntimeException("Removal through an immutable iterator is not permitted");
	}

	/**
     * Constructor for the ImmutableIterator class
     *
     * @param Iterator that will be used by the immutable iterator
     *
     */
	public ImmutableIterator(Iterator iterator)
	{
		mIterator = iterator;
	}
}

/****************************************************************
*
*                              File log
*
* $Log: ImmutableIterator.java,v $
* Revision 1.1  2003/03/20 16:00:03  marsha02
*
*
*
****************************************************************/