#########################################################################################
# SVM (Statechart Virtual Machine), an interpreter for an extended statechart formalism #
#########################################################################################

# Copyright (C) 2003 Thomas Huining Feng

# Address:      MSDL, SOCS, McGill Univ., Montreal, Canada
# HomePage:     http://msdl.cs.mcgill.ca/people/tfeng/
# SVM HomePage: http://msdl.cs.mcgill.ca/people/tfeng/?research=svm
# Download:     http://sourceforge.net/projects/pyuml/
# CVS:          :pserver:anonymous@cvs.sourceforge.net:/cvsroot/pyuml
# Email:        hfeng2@cs.mcgill.ca

# This file is part of SVM.

# SVM is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your
# option) any later version.

# SVM is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
# License for more details.

# You should have received a copy of the GNU General Public License
# along with SVM; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


import time
import code
import thread
from SnapShot import *

clock_lock=thread.allocate_lock()
start_lock=thread.allocate_lock()

#======================================================================#
# Clock class

class Clock:
 """ The Clock is a scheduler running in another thread. When it is time
     to raise an event, it runs the function func with parameter param.
 """
 def __init__(self, eventhandler):
   start_lock.acquire()
   self.eventhandler=eventhandler
   self.interval=None
   self.func=None
   self.param=None
   self.stopped=1
   self.inter=0
   self.autostop=0
   self.schedule_time=0
   self.first_interval=0
   start_lock.release()

 def start_ss(self, snapshot, func):
   start_lock.acquire()
   restore_snapshot(self, snapshot)
   self.func=func
   self.eventhandler.clocks.append(self)
   self.schedule_time=time.time()
   start_lock.release()
   thread.start_new_thread(self.ClockThread, (self.interval, func, self.param, self.autostop))

 def start(self, interval, func, param, autostop=0):
   start_lock.acquire()
   self.interval=interval
   self.func=func
   self.param=param
   self.stopped=0
   try:
     self.inter=float(self.interval)
   except:
     self.inter=0
   self.autostop=autostop
   self.eventhandler.clocks.append(self)
   self.schedule_time=time.time()
   self.first_interval=None
   start_lock.release()
   thread.start_new_thread(self.ClockThread, (self.interval, func, self.param, self.autostop))
 
 def remove(self):
   for i in range(len(self.eventhandler.clocks)):
     if self.eventhandler.clocks[i]==self:
       del self.eventhandler.clocks[i]
       break

 def stop(self):
   clock_lock.acquire()
   self.remove()
   self.schedule_time=None
   self.stopped=1
   clock_lock.release()
 
 def ClockThread(self, interval, func, param, autostop):
   while not self.stopped:
     clock_lock.acquire()
     self.schedule_time=time.time()
     clock_lock.release()
     if self.first_interval:
       time.sleep(self.first_interval)
       self.first_interval=None
     else:
       self.inter=eval(str(interval), sys.modules['__main__'].__dict__)
       time.sleep(self.inter)
     if not self.stopped:
       func(param)
     if autostop:
       clock_lock.acquire()
       self.remove()
       self.schedule_time=None
       clock_lock.release()   
       break
