#########################################################################################
# SVM (Statechart Virtual Machine), an interpreter for an extended statechart formalism #
#########################################################################################

# Copyright (C) 2003 Thomas Huining Feng

# Address:      MSDL, SOCS, McGill Univ., Montreal, Canada
# HomePage:     http://msdl.cs.mcgill.ca/people/tfeng/
# SVM HomePage: http://msdl.cs.mcgill.ca/people/tfeng/?research=svm
# Download:     http://sourceforge.net/projects/pyuml/
# CVS:          :pserver:anonymous@cvs.sourceforge.net:/cvsroot/pyuml
# Email:        hfeng2@cs.mcgill.ca

# This file is part of SVM.

# SVM is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your
# option) any later version.

# SVM is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
# License for more details.

# You should have received a copy of the GNU General Public License
# along with SVM; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


from java.awt import Dialog, Panel, BorderLayout, FlowLayout, GridLayout
from java.awt import Color, Font, Dimension
from java.awt.event import ComponentListener
from javax.swing import JTextArea, JButton, JTextPane, JScrollPane, JTextField, JPanel
from javax.swing.text import StyleConstants

from string import *
from MyStyle import MyStyle

ABOUT_LOGO1_1='Jython Implementation of Statechart Virtual Machine'
ABOUT_LOGO1_2='Version 0.2'
ABOUT_LOGO1_3='Presented by Thomas Feng, Feb. 2003'
ABOUT_LOGO2_1='Usage: jython svm.py [-t] <.des|.snp file> [parameters...]'
ABOUT_LOGO2_2='-t: force textual interface'
ABOUT_LOGO2_3='parameter: "name=value"'
EXAMPLE_1='Example:%s'%ljust('', 49)
EXAMPLE_2='jython svm.py datatypes/integer.des "INIT=5"'

class AboutBox(Dialog):
  def __init__(self, parent):
    Dialog.__init__(self, parent, 1,
                    windowClosing=self.window_close)
    self.setTitle("About jSVM")
    self.createWidgets()

    wndSize=self.getToolkit().getScreenSize()
    left=(wndSize.width-self.pwidth)/2
    top=(wndSize.height-self.pheight)/2
    self.setBounds(left, top, self.pwidth, self.pheight)

  def window_close(self, e=None):
    self.dispose()

  def createWidgets(self):
    p=Panel()
    p.setLayout(BorderLayout())

    bp=Panel()
    bp.setLayout(BorderLayout())
    
    tp=JPanel(border=MyStyle.border)
    tp.setLayout(GridLayout(3,1))

    tl1=JTextField(ABOUT_LOGO1_1, border=MyStyle.emptyborder)
    tl1.setEditable(0)
    tl1.setBackground(MyStyle.lightblue)
    tl1.setForeground(Color.red)
    tl1.setFont(MyStyle.vfont1b)
    tl1.setHorizontalAlignment(JTextField.CENTER)

    tl2=JTextField(ABOUT_LOGO1_2, border=MyStyle.emptyborder)
    tl2.setEditable(0)
    tl2.setBackground(MyStyle.lightblue)
    tl2.setForeground(Color.red)
    tl2.setFont(MyStyle.vfont1b)
    tl2.setHorizontalAlignment(JTextField.CENTER)

    tl3=JTextField(ABOUT_LOGO1_3, border=MyStyle.emptyborder)
    tl3.setEditable(0)
    tl3.setBackground(MyStyle.lightblue)
    tl3.setForeground(Color.red)
    tl3.setFont(MyStyle.vfont1b)
    tl3.setHorizontalAlignment(JTextField.CENTER)

    tp.add(tl1)
    tp.add(tl2)
    tp.add(tl3)

    p.add("Center", tp)
    p.add("South", bp)

    mp=JPanel()
    mp.setLayout(GridLayout(3,1))

    ml1=JTextField(ABOUT_LOGO2_1, border=MyStyle.emptyborder)
    ml1.setEditable(0)
    ml1.setBackground(MyStyle.pink)
    ml1.setForeground(Color.blue)
    ml1.setFont(MyStyle.ffont1)
    ml1.setHorizontalAlignment(JTextField.CENTER)

    ml2=JTextField(ABOUT_LOGO2_2, border=MyStyle.emptyborder)
    ml2.setEditable(0)
    ml2.setBackground(MyStyle.pink)
    ml2.setForeground(Color.blue)
    ml2.setFont(MyStyle.ffont1)
    ml2.setHorizontalAlignment(JTextField.CENTER)
    
    ml3=JTextField(ABOUT_LOGO2_3, border=MyStyle.emptyborder)
    ml3.setEditable(0)
    ml3.setBackground(MyStyle.pink)
    ml3.setForeground(Color.blue)
    ml3.setFont(MyStyle.ffont1)
    ml3.setHorizontalAlignment(JTextField.CENTER)

    mp.add(ml1)
    mp.add(ml2)
    mp.add(ml3)

    bp.add("Center", mp)

    bbp=Panel()
    bbp.setLayout(BorderLayout())

    blp=JPanel(border=MyStyle.border)
    blp.setLayout(GridLayout(2,1))
    
    bl1=JTextField(EXAMPLE_1, border=MyStyle.emptyborder)
    bl1.setEditable(0)
    bl1.setBackground(MyStyle.pink)
    bl1.setForeground(Color.blue)
    bl1.setFont(MyStyle.ffont1)
    bl1.setHorizontalAlignment(JTextField.CENTER)
    
    bl2=JTextField(EXAMPLE_2, border=MyStyle.emptyborder)
    bl2.setEditable(0)
    bl2.setBackground(MyStyle.pink)
    bl2.setForeground(Color.blue)
    bl2.setFont(MyStyle.ffont1)
    bl2.setHorizontalAlignment(JTextField.CENTER)

    blp.add(bl1)
    blp.add(bl2)

    bbp.add("Center", blp)

    bbbp=Panel()
    bbbp.setLayout(FlowLayout(FlowLayout.CENTER,0,0))
    bbbp.setBackground(Color(0xFFC0C0))
    closebtn=JButton("Close", border=MyStyle.border, background=MyStyle.lightyellow,
                    foreground=MyStyle.brown, preferredSize=(60,28),
                    font=MyStyle.vfont1b, actionPerformed=self.window_close)
    bbbp.add(closebtn)

    bbp.add("South", bbbp)
    bp.add("South", bbp)
    
    p.add("South", bp)

    self.add(p)

    self.pwidth=0
    self.pheight=0
    self.add_to_size(tl1.getPreferredSize())
    self.add_to_size(tl2.getPreferredSize())
    self.add_to_size(tl3.getPreferredSize())
    self.add_to_size(ml1.getPreferredSize())
    self.add_to_size(ml2.getPreferredSize())
    self.add_to_size(ml3.getPreferredSize())
    self.add_to_size(bl1.getPreferredSize())
    self.add_to_size(bl2.getPreferredSize())

  def add_to_size(self, d):
    d.width+=20
    d.height+=10
    if self.pwidth<d.width:
      self.pwidth=d.width
    self.pheight+=d.height
