/*
 * $Id: gettext.h,v 1.1 2003/12/30 23:20:19 jylefort Exp $
 *
 * Copyright (c) 2003, Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _GETTEXT_H
#define _GETTEXT_H

#ifdef ENABLE_NLS

#include <libintl.h>

#else /* ENABLE_NLS */

/*
 * Quoting GNU:
 *
 * "Solaris /usr/include/locale.h includes /usr/include/libintl.h,
 * which chokes if dcgettext is defined as a macro. So include it now,
 * to make later inclusions of <locale.h> a NOP. We don't include
 * <libintl.h> as well because people using "gettext.h" will not
 * include <libintl.h>, and also including <libintl.h> would fail on
 * SunOS 4, whereas <locale.h> is OK."
 */
#ifdef __sun
#include <locale.h>
#endif /* __sun */

/*
 * Quoting GNU:
 *
 * "Disabled NLS.
 * The casts to 'const char *' serve the purpose of producing warnings
 * for invalid uses of the value returned from these functions. On
 * pre-ANSI systems without 'const', the config.h file is supposed to
 * contain "#define const".
 */
#define gettext(Msgid)				((const char *) (Msgid))
#define dgettext(Domainname, Msgid)		((const char *) (Msgid))
#define dcgettext(Domainname, Msgid, Category)	((const char *) (Msgid))
#define ngettext(Msgid1, Msgid2, N) \
	((N) == 1 ? (const char *) (Msgid1) : (const char *) (Msgid2))
#define dngettext(Domainname, Msgid1, Msgid2, N) \
	((N) == 1 ? (const char *) (Msgid1) : (const char *) (Msgid2))
#define dcngettext(Domainname, Msgid1, Msgid2, N, Category) \
	((N) == 1 ? (const char *) (Msgid1) : (const char *) (Msgid2))
#define textdomain(Domainname)			((const char *) (Domainname))
#define bindtextdomain(Domainname, Dirname)	((const char *) (Dirname))
#define bind_textdomain_codeset(Domainname, Codeset) \
	((const char *) (Codeset))

#endif /* ENABLE_NLS */

/*
 * Quoting GNU:
 *
 * "A pseudo function call that serves as a marker for the automated
 * extraction of messages, but does not call gettext(). The run-time
 * translation is done at a different place in the code. The argument,
 * String, should be a literal string. Concatenated strings and other
 * string expressions won't work. The macro's expansion is not
 * parenthesized, so that it is suitable as initializer for static
 * 'char[]' or 'const char[]' variables.
 */
#define gettext_noop(String)	String

#define _(String)		dgettext(GETTEXT_PACKAGE, String)
#define N_(String)		gettext_noop(String)

#endif /* _GETTEXT_H */
