# $Id: vorbis.m4,v 1.2 2003/12/30 02:44:24 jylefort Exp $
#
# Copyright (c) 2003 Jean-Yves Lefort.
#
# This file is part of streamtuner-local.
# As a special exception to the streamtuner-local licensing terms,
# Jean-Yves Lefort gives unlimited permission to copy, distribute and
# modify this file.

dnl AM_PATH_VORBIS([HEADERS], [KEYWORDS], [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND], [ACTION-IF-WITHOUT])
dnl
AC_DEFUN(AM_PATH_VORBIS,
[AC_ARG_WITH(vorbis,
AC_HELP_STRING([--with-vorbis=PREFIX], [specify where libvorbis is installed [[autodetect]]]),
[with_vorbis=$withval],
[with_vorbis=yes])

AC_ARG_ENABLE(vorbistest,
AC_HELP_STRING(--disable-vorbistest,
[do not try to compile a test libvorbis program]),
[case "$enableval" in
	yes|no) enable_id3vorbis=$enableval;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-vorbistest]);;
esac], [enable_vorbistest=yes])

if test "x$with_vorbis" != xno; then
	if test "x$with_vorbis" = xyes; then
		AC_CHECK_FILE(/usr/include/vorbis/vorbisfile.h, [VORBIS_PREFIX=/usr])
		if test -z "$VORBIS_PREFIX"; then
			AC_CHECK_FILE(/usr/local/include/vorbis/vorbisfile.h, [VORBIS_PREFIX=/usr/local])
		fi
		if test -z "$VORBIS_PREFIX"; then
			AC_CHECK_FILE(/opt/include/vorbis/vorbisfile.h, [VORBIS_PREFIX=/opt])
		fi
		if test -z "$VORBIS_PREFIX"; then
			AC_MSG_ERROR([unable to determine the libvorbis prefix; you should specify it manually using --with-vorbis=PREFIX])
		fi
	else
		VORBIS_PREFIX="$with_vorbis"
	fi

	VORBIS_CFLAGS="-I$VORBIS_PREFIX/include"
	VORBIS_LIBS="-L$VORBIS_PREFIX/lib -lvorbis -lm"
	VORBISFILE_LIBS="-lvorbisfile"
	VORBISENC_LIBS="-lvorbisenc"

	found=yes
	
	if test $enable_vorbistest = yes; then
		ac_save_CFLAGS="$CFLAGS"
		ac_save_LIBS="$LIBS"
		CFLAGS="$CFLAGS $VORBIS_CFLAGS"
		LIBS="$LIBS $VORBIS_LIBS $VORBISFILE_LIBS"

		AC_MSG_CHECKING([for libvorbis])

		headers=""
		for header in [$1]; do
			headers="$headers
#include <$header>"
		done

		keywords=""
		for keyword in [$2]; do
			keywords="$keywords
  $keyword;"
		done

		AC_LINK_IFELSE([
$headers

int main () {
  $keywords
}
], [found=yes], [found=no])
		
		AC_MSG_RESULT($found)

		CFLAGS="$ac_save_CFLAGS"
		LIBS="$ac_save_LIBS"
	fi

	if test $found = yes; then
		ifelse([$3],, :, [$3])
	else
		VORBIS_PREFIX=""
		VORBIS_CFLAGS=""
		VORBIS_LIBS=""
		VORBISFILE_LIBS=""
		VORBISENC_LIBS=""
		ifelse([$4],, :, [$4])
	fi
else
	VORBIS_PREFIX=""
	VORBIS_CFLAGS=""
	VORBIS_LIBS=""
	VORBISFILE_LIBS=""
	VORBISENC_LIBS=""
	ifelse([$6],, :, [$6])
fi

AC_SUBST(VORBIS_PREFIX)
AC_SUBST(VORBIS_CFLAGS)
AC_SUBST(VORBIS_LIBS)
AC_SUBST(VORBISFILE_LIBS)
AC_SUBST(VORBISENC_LIBS)])
