# $Id: id3tag.m4,v 1.2 2003/12/30 02:06:10 jylefort Exp $
#
# Copyright (c) 2003 Jean-Yves Lefort.
#
# This file is part of streamtuner-local.
# As a special exception to the streamtuner-local licensing terms,
# Jean-Yves Lefort gives unlimited permission to copy, distribute and
# modify this file.
#
# Partially inspired by glib-2.0.m4 from Owen Taylor.

dnl AM_PATH_ID3TAG([MINIMUM-VERSION], [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND], [ACTION-IF-WITHOUT])
dnl
AC_DEFUN(AM_PATH_ID3TAG,
[AC_ARG_WITH(id3tag,
AC_HELP_STRING([--with-id3tag=PREFIX], [specify where libid3tag is installed [[autodetect]]]),
[with_id3tag=$withval],
[with_id3tag=yes])

AC_ARG_ENABLE(id3tagtest,
AC_HELP_STRING(--disable-id3tagtest,
[do not try to compile and run a test libid3tag program]),
[case "$enableval" in
	yes|no) enable_id3tagtest=$enableval;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-id3tagtest]);;
esac], [enable_id3tagtest=yes])

if test "x$with_id3tag" != xno; then
	if test "x$with_id3tag" = xyes; then
		AC_CHECK_FILE(/usr/include/id3tag.h, [ID3TAG_PREFIX=/usr])
		if test -z "$ID3TAG_PREFIX"; then
			AC_CHECK_FILE(/usr/local/include/id3tag.h, [ID3TAG_PREFIX=/usr/local])
		fi
		if test -z "$ID3TAG_PREFIX"; then
			AC_CHECK_FILE(/opt/include/id3tag.h, [ID3TAG_PREFIX=/opt])
		fi
		if test -z "$ID3TAG_PREFIX"; then
			AC_MSG_ERROR([unable to determine the libid3tag prefix; you should specify it manually using --with-id3tag=PREFIX])
		fi
	else
		ID3TAG_PREFIX="$with_id3tag"
	fi

	ID3TAG_CFLAGS="-I$ID3TAG_PREFIX/include"
	ID3TAG_LIBS="-L$ID3TAG_PREFIX/lib -lid3tag"

	found=yes
	id3tag_min_version=ifelse([$1],, 0.15, [$1])

	if test $enable_id3tagtest = yes; then
		ac_save_CFLAGS="$CFLAGS"
		ac_save_LIBS="$LIBS"
		CFLAGS="$CFLAGS $ID3TAG_CFLAGS"
		LIBS="$LIBS $ID3TAG_LIBS"

		AC_MSG_CHECKING([for libid3tag >= $id3tag_min_version])

		AC_TRY_RUN([
#include <id3tag.h>
#include <stdio.h>
#include <stdlib.h>

int main () {
  int major, minor;

  if (sscanf("$id3tag_min_version", "%d.%d", &major, &minor) != 2)
    exit(96); /* bad version string */

  if ((ID3_TAG_VERSION_MAJOR(ID3_TAG_VERSION) > major) ||
      ((ID3_TAG_VERSION_MAJOR(ID3_TAG_VERSION) == major) && (ID3_TAG_VERSION_MINOR(ID3_TAG_VERSION) >= minor)))
    exit(0);
  else
    exit(97); /* version too old */
}
],, [found=no], [found=yes])

		AC_MSG_RESULT($found)

		CFLAGS="$ac_save_CFLAGS"
		LIBS="$ac_save_LIBS"
	fi

	if test $found = yes; then
		ifelse([$2],, :, [$2])
	else
		ID3TAG_PREFIX=""
		ID3TAG_CFLAGS=""
		ID3TAG_LIBS=""
		ifelse([$3],, :, [$3])
	fi
else
	ID3TAG_PREFIX=""
	ID3TAG_CFLAGS=""
	ID3TAG_LIBS=""
	ifelse([$4],, :, [$4])
fi

AC_SUBST(ID3TAG_PREFIX)
AC_SUBST(ID3TAG_CFLAGS)
AC_SUBST(ID3TAG_LIBS)])
