/*
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "st-handler-field.h"

/*** type definitions ********************************************************/

struct _STHandlerFieldPrivate
{
  GType		type;
  char		*label;
  unsigned int	flags;

  gboolean	user_visible;
  int		width;
};

/*** API implementation ******************************************************/

STHandlerField *
st_handler_field_new (int id, const char *label, GType type, unsigned int flags)
{
  STHandlerField *field;

  g_return_val_if_fail(label != NULL, NULL);
  g_return_val_if_fail(type == G_TYPE_BOOLEAN
		       || type == G_TYPE_INT
		       || type == G_TYPE_STRING
		       || type == GDK_TYPE_PIXBUF
		       || (type == G_TYPE_VALUE_ARRAY && (flags & ST_HANDLER_FIELD_EDITABLE) == 0), NULL);
  
  field = g_new(STHandlerField, 1);
  field->id = id;

  field->priv = g_new(STHandlerFieldPrivate, 1);
  field->priv->type = type;
  field->priv->label = g_strdup(label);
  field->priv->flags = flags;
  field->priv->user_visible = (field->priv->flags & ST_HANDLER_FIELD_START_HIDDEN) == 0;
  field->priv->width = ST_HANDLER_FIELD_DEFAULT_WIDTH;

  return field;
}

/*
 * This has nothing to do with the usual GObject _get_type() function.
 */
GType
st_handler_field_get_type (STHandlerField *field)
{
  g_return_val_if_fail(field != NULL, -1);

  return field->priv->type;
}

const char *
st_handler_field_get_label (STHandlerField *field)
{
  g_return_val_if_fail(field != NULL, NULL);
  
  return field->priv->label;
}

unsigned int
st_handler_field_get_flags (STHandlerField *field)
{
  g_return_val_if_fail(field != NULL, 0);

  return field->priv->flags;
}

/*** private implementation **************************************************/

void
st_handler_field_set_user_visible (STHandlerField *field,
				   gboolean user_visible)
{
  g_return_if_fail(field != NULL);

  field->priv->user_visible = user_visible;
}

gboolean
st_handler_field_get_user_visible (STHandlerField *field)
{
  g_return_val_if_fail(field != NULL, FALSE);

  return field->priv->user_visible;
}

void
st_handler_field_set_width (STHandlerField *field, int width)
{
  g_return_if_fail(field != NULL);

  field->priv->width = width;
}

int
st_handler_field_get_width (STHandlerField *field)
{
  g_return_val_if_fail(field != NULL, -1);

  return field->priv->width;
}
