/*
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_HANDLER_FIELD_API_H
#define _ST_HANDLER_FIELD_API_H

#include <glib-object.h>

#define ST_HANDLER_FIELD_VISIBLE		(1 << 0)
#define ST_HANDLER_FIELD_EDITABLE		(1 << 1)
#define ST_HANDLER_FIELD_VOLATILE		(1 << 2)
#define ST_HANDLER_FIELD_NO_DEDICATED_COLUMN	(1 << 3)
#define ST_HANDLER_FIELD_START_HIDDEN		(1 << 4)

typedef struct _STHandlerFieldPrivate STHandlerFieldPrivate;

typedef struct
{
  int				id;
  STHandlerFieldPrivate		*priv;
} STHandlerField;

STHandlerField	*st_handler_field_new		(int		id,
						 const char	*label,
						 GType		type,
						 unsigned int	flags);

const char	*st_handler_field_get_label	(STHandlerField	*field);
GType		st_handler_field_get_type	(STHandlerField	*field);
unsigned int	st_handler_field_get_flags	(STHandlerField	*field);

#endif /* _ST_HANDLER_FIELD_API_H */
