/*
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _PST_HELPERS_H
#define _PST_HELPERS_H

#include <Python.h>
#include "streamtuner.h"

typedef struct
{
  PyObject	*object;
  char		*method;
} PSTCallbackInfo;

gboolean	pst_strings_as_gslist     (PyObject	*strings,
					   GSList	**gslist);
PyObject	*pst_strings_from_gslist  (GSList	*gslist);

PyObject	*pst_object_from_gvalue   (const GValue	*gvalue);
void		pst_object_as_gvalue      (PyObject	*object,
					   GValue	*gvalue);

PyObject	*pst_none                 (void);

PyObject	*pst_string_getter        (const char	*str);
int		pst_string_setter         (char		**ptr,
					   PyObject	*value);

gboolean	pst_streams_as_glist      (PyObject	*streams,
					   GList	**list,
					   GError	**err);
GHashTable	*pst_streams_mapping_as_ghashtable (PyObject	*streams,
						    GError	**err);

void		pst_set_error             (GError	**err);

#endif /* _PST_HELPERS_H */
