# This file is part of streamtuner.
#
# Copyright (c) 2004 Jean-Yves Lefort.
#
# As a special exception to the streamtuner licensing terms, Jean-Yves
# Lefort gives unlimited permission to copy, distribute and modify
# this file.

dnl AM_PATH_TAGLIB_C([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl
AC_DEFUN([AM_PATH_TAGLIB_C],
[AC_PATH_PROG(TAGLIB_CONFIG, taglib-config, no)

if test "x$TAGLIB_CONFIG" = xno; then
	TAGLIB_PREFIX=""
	TAGLIB_CFLAGS=""
	TAGLIB_LIBS=""

	ifelse([$2],, :, [$2])
else
	TAGLIB_PREFIX=`$TAGLIB_CONFIG --prefix`

	# We set CFLAGS and LIBS ourselves, because taglib-config
	# returns CFLAGS and LIBS for the C++ library.

	TAGLIB_CFLAGS="-I$TAGLIB_PREFIX/include/taglib"
	TAGLIB_LIBS="-L$TAGLIB_PREFIX/lib -ltag_c"

	ac_save_CFLAGS="$CFLAGS"
	ac_save_LIBS="$LIBS"
	CFLAGS="$CFLAGS $TAGLIB_CFLAGS"
	LIBS="$LIBS $TAGLIB_LIBS"

	AC_MSG_CHECKING([for TagLib])

	AC_COMPILE_IFELSE([
#include <tag_c.h>

int main() {
  taglib_file_new;
}
], [found=yes], [found=no])

	AC_MSG_RESULT($found)

	CFLAGS="$ac_save_CFLAGS"
	LIBS="$ac_save_LIBS"

	if test $found = yes; then
		ifelse([$1],, :, [$1])
	else
		TAGLIB_PREFIX=""
		TAGLIB_CFLAGS=""
		TAGLIB_LIBS=""

		ifelse([$2],, :, [$2])
	fi
fi

AC_SUBST(TAGLIB_PREFIX)
AC_SUBST(TAGLIB_CFLAGS)
AC_SUBST(TAGLIB_LIBS)])
