/*
 * $Id: sgtk-handlers.c,v 1.15 2004/03/08 05:57:37 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "sgtk-handlers.h"

/*** implementation **********************************************************/

/*
 * Handles popup-menu signals.
 */
gboolean
sgtk_popup_menu_h (gpointer data)
{
  GtkMenu *menu = data;
  
  g_return_val_if_fail(GTK_IS_MENU(menu), FALSE);

  gtk_menu_popup(menu, NULL, NULL, NULL, NULL, 0, gtk_get_current_event_time());

  return TRUE;
}

/*
 * Handles button-press-event signals: popups the GtkMenu passed as
 * data if the right mouse button was clicked.
 */
int
sgtk_popup_menu_mouse_h (gpointer data, GdkEvent *event)
{
  GtkMenu *menu = data;

  g_return_val_if_fail(GTK_IS_MENU(menu), FALSE);
  g_return_val_if_fail(event != NULL, FALSE);

  if (event->type == GDK_BUTTON_PRESS)
    {
      GdkEventButton *event_button = (GdkEventButton *) event;

      if (event_button->button == 3)
	gtk_menu_popup(menu, NULL, NULL, NULL, NULL,
		       event_button->button, event_button->time);
    }

  return FALSE;
}
