/*
 * $Id: st-util.c,v 1.2.2.2 2004/05/11 15:40:42 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <gtk/gtk.h>
#include "art/streamtuner_logo.h"
#include "gettext.h"
#include "st-action.h"
#include "st-dialog-api.h"

GtkWidget *
st_logo_new (void)
{
  GtkWidget *image;
  GtkWidget *event_box;
  GdkPixbuf *logo;
  GdkColor bg = { 0, 0xFFFF, 0xF000, 0x0000 };

  logo = gdk_pixbuf_new_from_inline(sizeof(art_streamtuner_logo),
				    art_streamtuner_logo,
				    FALSE,
				    NULL);
  image = gtk_image_new_from_pixbuf(logo);
  g_object_unref(logo);

  event_box = gtk_event_box_new();
  gtk_widget_modify_bg(event_box, GTK_STATE_NORMAL, &bg);
  gtk_container_add(GTK_CONTAINER(event_box), image);

  gtk_widget_show(image);

  return event_box;
}

void
st_show_help (const char *link_id)
{
  char *filename;

  filename = g_build_filename(BASEDOCDIR, "C", "streamtuner.xml", NULL);

  if (g_file_test(filename, G_FILE_TEST_EXISTS))
    {
      char *uri;
      gboolean status;
      GError *err = NULL;
      
      uri = link_id
	? g_strconcat("ghelp://", filename, "?", link_id, NULL)
	: g_strconcat("ghelp://", filename, NULL);

      status = st_action_run("view-ghelp", uri, &err);
      g_free(uri);

      if (! status)
	{
	  char *normalized;

	  normalized = st_dialog_normalize(err->message);
	  g_error_free(err);

	  st_error_dialog(_("Unable to view the manual."), "%s", normalized);
	  g_free(normalized);
	}
    }
  else
    st_error_dialog(_("Unable to view the manual."),
		    _("The manual file %s does not exist."), filename);
  
  g_free(filename);
}
