/*
 * $Id: st-stock.c,v 1.22 2004/01/27 14:16:42 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "art/add_bookmark.h"
#include "art/tune_in.h"
#include "art/tune_in_prelight.h"
#include "art/record.h"
#include "art/record_prelight.h"
#include "art/browse.h"
#include "art/browse_prelight.h"
#include "art/search.h"
#include "art/bookmarks.h"
#include "art/category.h"
#include "art/category_open.h"
#include "st-stock.h"

/*** constant definitions ****************************************************/

static const GtkStockItem items[] = {
  { ST_STOCK_TUNE_IN,			N_("_Tune in"),		0, 0,	NULL },
  { ST_STOCK_RECORD,			N_("_Record"),		0, 0,	NULL },
  { ST_STOCK_BROWSE,			N_("_Browse"),		0, 0,	NULL },
  
  { ST_STOCK_QUIT_WITHOUT_SAVING,	N_("_Quit Without Saving"),	0, 0, NULL },
  { ST_STOCK_OPEN_LINK,			N_("_Open Link"),	0, 0,	NULL },
  { ST_STOCK_COPY_LINK_ADDRESS,		N_("_Copy Link Address"),	0, 0, NULL },

  { ST_STOCK_ADD_BOOKMARK,		N_("_Add Bookmark"),	0, 0,	NULL }
};

/*** implementation **********************************************************/

void
st_stock_init (void)
{
  GtkIconFactory *factory;
  int i;

  const struct
  {
    const char		*stock_id;
    const char		*stock_image;

    const guint8	*data;
    int			data_size;

    const guint8	*prelight_data;
    int			prelight_data_size;
  } icons[] = {
    {
      ST_STOCK_TUNE_IN,		NULL,
      art_tune_in,		sizeof(art_tune_in),
      art_tune_in_prelight,	sizeof(art_tune_in_prelight)
    },
    {
      ST_STOCK_RECORD,		NULL,
      art_record,		sizeof(art_record),
      art_record_prelight,	sizeof(art_record_prelight)
    },
    {
      ST_STOCK_BROWSE,		NULL,
      art_browse,		sizeof(art_browse),
      art_browse_prelight,	sizeof(art_browse_prelight)
    },
    {
      ST_STOCK_QUIT_WITHOUT_SAVING,	GTK_STOCK_QUIT,
      NULL,			0,
      NULL,			0
    },
    {
      ST_STOCK_SEARCH,		NULL,
      art_search,		sizeof(art_search),
      NULL,			0
    },
    {
      ST_STOCK_OPEN_LINK,	GTK_STOCK_OPEN,
      NULL,			0,
      NULL,			0
    },
    {
      ST_STOCK_COPY_LINK_ADDRESS,	GTK_STOCK_COPY,
      NULL,			0,
      NULL,			0
    },
    {
      ST_STOCK_ADD_BOOKMARK,	NULL,
      art_add_bookmark,		sizeof(art_add_bookmark),
      NULL,			0
    },
    {
      ST_STOCK_BOOKMARKS,	NULL,
      art_bookmarks,		sizeof(art_bookmarks),
      NULL,			0
    },
    {
      ST_STOCK_CATEGORY,	NULL,
      art_category,		sizeof(art_category),
      NULL,			0
    },
    {
      ST_STOCK_CATEGORY_OPEN,	NULL,
      art_category_open,	sizeof(art_category_open),
      NULL,			0
    }
  };
  
  factory = gtk_icon_factory_new();
  gtk_icon_factory_add_default(factory);

  for (i = 0; i < G_N_ELEMENTS(icons); i++)
    {
      GtkIconSet *icon_set;

      if (icons[i].stock_image)
	{
	  icon_set = gtk_icon_factory_lookup_default(icons[i].stock_image);
	  gtk_icon_set_ref(icon_set);
	}
      else
	{
	  GdkPixbuf *pixbuf;

	  pixbuf = gdk_pixbuf_new_from_inline(icons[i].data_size,
					      icons[i].data,
					      FALSE,
					      NULL);
	  g_assert(pixbuf != NULL);
	  
	  icon_set = gtk_icon_set_new_from_pixbuf(pixbuf);
	  g_object_unref(pixbuf);

	  if (icons[i].prelight_data)
	    {
	      GdkPixbuf *prelight_pixbuf;
	      GtkIconSource *icon_source;
	      
	      prelight_pixbuf = gdk_pixbuf_new_from_inline(icons[i].prelight_data_size,
							   icons[i].prelight_data,
							   FALSE,
							   NULL);
	      g_assert(prelight_pixbuf != NULL);
	      
	      icon_source = gtk_icon_source_new();
	      
	      gtk_icon_source_set_pixbuf(icon_source, prelight_pixbuf);
	      gtk_icon_source_set_direction_wildcarded(icon_source, TRUE);
	      gtk_icon_source_set_state_wildcarded(icon_source, FALSE);
	      gtk_icon_source_set_state(icon_source, GTK_STATE_PRELIGHT);
	      gtk_icon_source_set_size_wildcarded(icon_source, TRUE);
	      
	      gtk_icon_set_add_source(icon_set, icon_source);
	      
	      g_object_unref(prelight_pixbuf);
	      gtk_icon_source_free(icon_source);
	    }
	}
      
      gtk_icon_factory_add(factory, icons[i].stock_id, icon_set);
      gtk_icon_set_unref(icon_set);
    }

  g_object_unref(factory);

  gtk_stock_add_static(items, G_N_ELEMENTS(items));
}
