/*
 * $Id: st-shell.h,v 1.19 2004/01/30 16:26:40 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_SHELL_H
#define _ST_SHELL_H

#include <gtk/gtk.h>
#include "st-browser-window.h"

extern GtkTooltips *st_shell_tooltips;

void		st_shell_main				(void);
void		st_shell_quit				(void);

GtkWindow *	st_shell_get_transient			(void);

gboolean	st_shell_can_tune_in			(void);
void		st_shell_tune_in			(void);

gboolean	st_shell_can_record			(void);
void		st_shell_record				(void);

gboolean	st_shell_can_browse			(void);
void		st_shell_browse				(void);

gboolean	st_shell_can_refresh			(void);
void		st_shell_refresh			(void);

void		st_shell_update_tab			(void);

gboolean	st_shell_can_present_stream_properties	(void);
void		st_shell_present_stream_properties	(void);

void		st_shell_present_preferences		(void);
void		st_shell_present_about_dialog		(void);

void		st_shell_help				(void);
void		st_shell_homepage			(void);

gboolean	st_shell_can_visit_directory_homepage	(void);
void		st_shell_visit_directory_homepage	(void);

void		st_shell_load_session			(void);
void		st_shell_save_session			(void);

void		st_shell_load_plugins			(void);

void		st_shell_previous_tab			(void);
void		st_shell_next_tab			(void);

void		st_shell_set_handler			(STHandler *handler);

void		st_shell_tab_selected			(void);
void		st_shell_streams_selected		(void);
void		st_shell_visibility_changed		(void);
void		st_shell_toolbar_style_changed		(void);
void		st_shell_toolbar_size_changed		(void);

gboolean	st_shell_can_add_bookmark		(void);
void		st_shell_add_bookmark			(void);

gboolean	st_shell_can_remove_bookmark		(void);
void		st_shell_remove_bookmark		(void);

void		st_shell_stop_task			(STThread *thread);

gboolean	st_shell_can_stop			(void);
void		st_shell_stop				(void);

#endif /* _ST_SHELL_H */
