/*
 * $Id: st-menubar.h,v 1.30 2004/01/30 12:25:33 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_MENUBAR_H
#define _ST_MENUBAR_H

#include "st-stream-menu-items.h"
#include "st-browser-tab.h"

#define ST_TYPE_MENUBAR			(st_menubar_get_type())
#define ST_MENUBAR(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_MENUBAR, STMenubar))
#define ST_MENUBAR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_MENUBAR, STMenubarClass))
#define ST_IS_MENUBAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_MENUBAR))
#define ST_IS_MENUBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_MENUBAR))
#define ST_MENUBAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_MENUBAR, STMenubarClass))

typedef struct
{
  GtkMenuBar		menubar;

  GtkAccelGroup		*accel_group;
  GtkItemFactory	*factory;

  GtkWidget		*stop_item;
  GtkWidget		*refresh_item;
  GtkWidget		*columns_item;
  GtkWidget		*directory_homepage_item;

  STStreamMenuItems	*stream_items;
  GSList		*directories_items;
} STMenubar;

typedef struct
{
  GtkMenuBarClass	parent_class;
} STMenubarClass;

GType		st_menubar_get_type		(void);
GtkWidget	*st_menubar_new			(GtkAccelGroup	*accel_group);

void		st_menubar_set_tab		(STMenubar	*menubar,
						 STBrowserTab	*tab);
void		st_menubar_update_sensitivity	(STMenubar	*menubar);

#endif /* _ST_MENUBAR_H */
