/*
 * $Id: st-general-tab.c,v 1.18 2004/01/08 13:47:08 jylefort Exp $
 *
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "gettext.h"
#include "art/general_preferences.h"
#include "sgtk-hig.h"
#include "st-general-tab.h"
#include "st-preferences.h"
#include "st-settings.h"
#include "st-preferences-tab.h"
#include "st-shell.h"

/*** function declarations ***************************************************/

static void st_general_tab_init (STGeneralTab *tab);

/*** implementation **********************************************************/

GType
st_general_tab_get_type (void)
{
  static GType general_tab_type = 0;
  
  if (! general_tab_type)
    {
      static const GTypeInfo general_tab_info = {
	sizeof(STGeneralTabClass),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	sizeof(STGeneralTab),
	0,
	(GInstanceInitFunc) st_general_tab_init,
      };

      general_tab_type = g_type_register_static(ST_TYPE_PREFERENCES_TAB,
						"STGeneralTab",
						&general_tab_info,
						0);
    }

  return general_tab_type;
}

static void
st_general_tab_init (STGeneralTab *tab)
{
  GdkPixbuf *pixbuf;

  pixbuf = gdk_pixbuf_new_from_inline(sizeof(art_general_preferences),
				      art_general_preferences,
				      FALSE,
				      NULL);

  st_preferences_tab_construct_label(ST_PREFERENCES_TAB(tab),
				     pixbuf,
				     _("General"));
  g_object_unref(pixbuf);

  gtk_container_set_border_width(GTK_CONTAINER(tab), SGTK_HIG_CONTROLS_BORDER_WIDTH);

  tab->save_automatic_check = gtk_check_button_new_with_mnemonic(_("_Save session upon exit"));
  gtk_tooltips_set_tip(st_shell_tooltips, tab->save_automatic_check,
		       _("If enabled, your session will be saved upon exit.\n"
		       "Otherwise, you'll be asked what to do."),
		       NULL);

  tab->always_refresh_check = gtk_check_button_new_with_mnemonic(_("_Always refresh categories"));
  gtk_tooltips_set_tip(st_shell_tooltips, tab->always_refresh_check,
		       _("If enabled, categories will always be refreshed when you enter them."),
		       NULL);

  st_preferences_bind_boolean(GTK_TOGGLE_BUTTON(tab->save_automatic_check),
			      &st_settings.save_automatic);
  st_preferences_bind_boolean(GTK_TOGGLE_BUTTON(tab->always_refresh_check),
			      &st_settings.always_refresh);
 
  tab->table = gtk_table_new(2, 1, FALSE);

  gtk_table_set_row_spacings(GTK_TABLE(tab->table), SGTK_HIG_CONTROL_SPACING);
  gtk_table_set_col_spacings(GTK_TABLE(tab->table), SGTK_HIG_CONTROL_SPACING);

  gtk_table_attach(GTK_TABLE(tab->table), tab->save_automatic_check, 0, 1, 0, 1,
		   GTK_EXPAND | GTK_FILL,
		   (GtkAttachOptions) 0,
		   0,
		   0);
  gtk_table_attach(GTK_TABLE(tab->table), tab->always_refresh_check, 0, 1, 1, 2,
		   GTK_EXPAND | GTK_FILL,
		   (GtkAttachOptions) 0,
		   0,
		   0);

  gtk_widget_show_all(tab->table);
  gtk_container_add(GTK_CONTAINER(tab), tab->table);
}

GtkWidget *
st_general_tab_new (void)
{
  return g_object_new(ST_TYPE_GENERAL_TAB, NULL);
}
