/*
 * $Id: sgtk-tree-view.c,v 1.6 2004/01/05 19:44:09 jylefort Exp $
 *
 * Copyright (c) 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>

/*** function declarations ***************************************************/

static gboolean sgtk_tree_view_get_count_cb (GtkTreeModel	*model,
					     GtkTreePath	*path,
					     GtkTreeIter	*iter,
					     gpointer		data);

/*** implementation **********************************************************/

gboolean
sgtk_tree_view_is_empty (GtkTreeView *view)
{
  GtkTreeModel *model;
  GtkTreeIter iter;

  g_return_val_if_fail(GTK_IS_TREE_VIEW(view), FALSE);

  model = gtk_tree_view_get_model(view);
  g_return_val_if_fail(model != NULL, FALSE);
  
  return ! gtk_tree_model_get_iter_first(model, &iter);
}

int
sgtk_tree_view_get_count (GtkTreeView *view)
{
  GtkTreeModel *model;
  int count = 0;

  g_return_val_if_fail(GTK_IS_TREE_VIEW(view), -1);

  model = gtk_tree_view_get_model(view);
  g_return_val_if_fail(model != NULL, -1);

  gtk_tree_model_foreach(model, sgtk_tree_view_get_count_cb, &count);
  
  return count;
}

static gboolean
sgtk_tree_view_get_count_cb (GtkTreeModel *model,
			     GtkTreePath *path,
			     GtkTreeIter *iter,
			     gpointer data)
{
  int *count = data;

  (*count)++;

  return FALSE;
}
