/*
 * $Id: st-toolbar.c,v 1.26 2004/01/30 12:30:23 jylefort Exp $
 *
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "gettext.h"
#include "sgtk-hig.h"
#include "st-toolbar.h"
#include "st-stock.h"
#include "st-shell.h"
#include "st-handler.h"
#include "st-handlers.h"
#include "st-link.h"

#define ST_TOOLBAR_APPEND_BUTTON(toolbar, stock_id, tooltip_text, cb) \
  gtk_toolbar_insert_stock(GTK_TOOLBAR(toolbar),	\
			   stock_id,			\
			   tooltip_text,		\
			   NULL,			\
			   cb,				\
			   NULL,			\
			   -1)

/*** function declarations ***************************************************/

static void st_toolbar_init (STToolbar *toolbar);

/*** implementation **********************************************************/

GType
st_toolbar_get_type (void)
{
  static GType toolbar_type = 0;
  
  if (! toolbar_type)
    {
      static const GTypeInfo toolbar_info = {
	sizeof(STToolbarClass),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	sizeof(STToolbar),
	0,
	(GInstanceInitFunc) st_toolbar_init,
      };
      
      toolbar_type = g_type_register_static(GTK_TYPE_TOOLBAR,
					    "STToolbar",
					    &toolbar_info,
					    0);
    }
  
  return toolbar_type;
}

static void
st_toolbar_init (STToolbar *toolbar)
{
  toolbar->tune_in = ST_TOOLBAR_APPEND_BUTTON(toolbar,
					      ST_STOCK_TUNE_IN,
					      _("Listen to the selected stream"),
					      st_shell_tune_in);
  toolbar->record = ST_TOOLBAR_APPEND_BUTTON(toolbar,
					     ST_STOCK_RECORD,
					     _("Record the selected stream"),
					     st_shell_record);
  toolbar->browse = ST_TOOLBAR_APPEND_BUTTON(toolbar,
					     ST_STOCK_BROWSE,
					     _("Browse the selected stream's website"),
					     st_shell_browse);
  toolbar->stop = ST_TOOLBAR_APPEND_BUTTON(toolbar,
					   GTK_STOCK_STOP,
					   _("Stop the currently running tasks"),
					   st_shell_stop);
  toolbar->refresh = ST_TOOLBAR_APPEND_BUTTON(toolbar,
					      GTK_STOCK_REFRESH,
					      _("Refresh the selected category"),
					      st_shell_refresh);

  toolbar->handler = NULL;

  if (st_handlers_list)
    {
      gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

      toolbar->handler_link = st_link_new();

      gtk_widget_show(toolbar->handler_link);
      gtk_container_set_border_width(GTK_CONTAINER(toolbar->handler_link), SGTK_HIG_CONTROL_SPACING);

      gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar),
				toolbar->handler_link,
				NULL,
				NULL);
    }
  else
    toolbar->handler_link = NULL;
}

GtkWidget *
st_toolbar_new (void)
{
  return g_object_new(ST_TYPE_TOOLBAR, NULL);
}

void
st_toolbar_update_sensitivity (STToolbar *toolbar)
{
  g_return_if_fail(ST_IS_TOOLBAR(toolbar));

  gtk_widget_set_sensitive(toolbar->tune_in, st_shell_can_tune_in());
  gtk_widget_set_sensitive(toolbar->record, st_shell_can_record());
  gtk_widget_set_sensitive(toolbar->browse, st_shell_can_browse());
  gtk_widget_set_sensitive(toolbar->stop, st_shell_can_stop());
  gtk_widget_set_sensitive(toolbar->refresh, st_shell_can_refresh());
}

void
st_toolbar_set_style (STToolbar *toolbar, STToolbarStyle style)
{
  GtkToolbarStyle gtk_style;

  g_return_if_fail(ST_IS_TOOLBAR(toolbar));

  if (style == ST_TOOLBAR_STYLE_GTK)

    {
      GtkSettings *settings;
      
      settings = gtk_widget_get_settings(GTK_WIDGET(toolbar));
      g_return_if_fail(settings != NULL);

      g_object_get(settings, "gtk-toolbar-style", &gtk_style, NULL);
    }
  else
    gtk_style = style;

  gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), gtk_style);
}

void
st_toolbar_set_size (STToolbar *toolbar, STToolbarSize size)
{
  GtkIconSize gtk_size;

  g_return_if_fail(ST_IS_TOOLBAR(toolbar));

  if (size == ST_TOOLBAR_SIZE_GTK)
    {
      GtkSettings *settings;
      
      settings = gtk_widget_get_settings(GTK_WIDGET(toolbar));
      g_return_if_fail(settings != NULL);

      g_object_get(settings, "gtk-toolbar-icon-size", &gtk_size, NULL);
    }
  else
    gtk_size = size;

  gtk_toolbar_set_icon_size(GTK_TOOLBAR(toolbar), gtk_size);
}

void
st_toolbar_set_handler (STToolbar *toolbar, STHandler *handler)
{
  char *markup;

  g_return_if_fail(ST_IS_TOOLBAR(toolbar));
  g_return_if_fail(handler != NULL);

  toolbar->handler = handler;

  markup = g_strdup_printf("<span size=\"x-large\">%s</span>", handler->description ? handler->description : handler->label);
  st_link_set_text(ST_LINK(toolbar->handler_link), markup);
  g_free(markup);

  st_link_set_uri(ST_LINK(toolbar->handler_link), handler->home);
}
